/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.TypedQueryReference;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.naming.Referenceable;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.GraphParser;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.internal.RootGraphImpl;
import org.hibernate.internal.TransactionManagement;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.relational.SchemaManager;
import org.hibernate.stat.Statistics;

public interface SessionFactory
extends EntityManagerFactory,
Referenceable,
Serializable {
    public String getJndiName();

    public SessionBuilder withOptions();

    public Session openSession() throws HibernateException;

    public Session getCurrentSession() throws HibernateException;

    public StatelessSessionBuilder withStatelessOptions();

    public StatelessSession openStatelessSession();

    public StatelessSession openStatelessSession(Connection var1);

    default public void inSession(Consumer<? super Session> action) {
        try (Session session = this.openSession();){
            action.accept(session);
        }
    }

    default public void inStatelessSession(Consumer<? super StatelessSession> action) {
        try (StatelessSession session = this.openStatelessSession();){
            action.accept(session);
        }
    }

    default public void inTransaction(Consumer<? super Session> action) {
        this.inSession(session -> TransactionManagement.manageTransaction(session, session.beginTransaction(), action));
    }

    default public void inStatelessTransaction(Consumer<? super StatelessSession> action) {
        this.inStatelessSession(session -> TransactionManagement.manageTransaction(session, session.beginTransaction(), action));
    }

    default public <R> R fromSession(Function<? super Session, R> action) {
        try (Session session = this.openSession();){
            R r = action.apply(session);
            return r;
        }
    }

    default public <R> R fromStatelessSession(Function<? super StatelessSession, R> action) {
        try (StatelessSession session = this.openStatelessSession();){
            R r = action.apply(session);
            return r;
        }
    }

    default public <R> R fromTransaction(Function<? super Session, R> action) {
        return (R)this.fromSession(session -> TransactionManagement.manageTransaction(session, session.beginTransaction(), action));
    }

    default public <R> R fromStatelessTransaction(Function<? super StatelessSession, R> action) {
        return (R)this.fromStatelessSession(session -> TransactionManagement.manageTransaction(session, session.beginTransaction(), action));
    }

    public Session createEntityManager();

    public Session createEntityManager(Map<?, ?> var1);

    public Session createEntityManager(SynchronizationType var1);

    public Session createEntityManager(SynchronizationType var1, Map<?, ?> var2);

    public Statistics getStatistics();

    public SchemaManager getSchemaManager();

    public HibernateCriteriaBuilder getCriteriaBuilder();

    public void close() throws HibernateException;

    public boolean isClosed();

    public Cache getCache();

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> var1);

    public RootGraph<?> findEntityGraphByName(String var1);

    default public <T> RootGraph<T> createEntityGraph(Class<T> entityType) {
        return new RootGraphImpl(null, (EntityDomainType)this.getMetamodel().entity(entityType));
    }

    public RootGraph<Map<String, ?>> createGraphForDynamicEntity(String var1);

    default public <T> RootGraph<T> parseEntityGraph(Class<T> rootEntityClass, CharSequence graphText) {
        return GraphParser.parse(rootEntityClass, (CharSequence)graphText.toString(), (SessionFactory)this.unwrap(SessionFactoryImplementor.class));
    }

    default public <T> RootGraph<T> parseEntityGraph(String rootEntityName, CharSequence graphText) {
        return GraphParser.parse(rootEntityName, (CharSequence)graphText.toString(), (SessionFactory)this.unwrap(SessionFactoryImplementor.class));
    }

    default public <T> RootGraph<T> parseEntityGraph(CharSequence graphText) {
        return GraphParser.parse(graphText.toString(), (SessionFactory)this.unwrap(SessionFactoryImplementor.class));
    }

    public Set<String> getDefinedFilterNames();

    @Deprecated(since="6.2")
    public FilterDefinition getFilterDefinition(String var1) throws HibernateException;

    public Set<String> getDefinedFetchProfileNames();

    default public boolean containsFetchProfileDefinition(String name) {
        return this.getDefinedFilterNames().contains(name);
    }

    @Incubating
    public <R> TypedQueryReference<R> addNamedQuery(String var1, TypedQuery<R> var2);

    public String getName();

    @Deprecated(since="6.2")
    public SessionFactoryOptions getSessionFactoryOptions();
}

