/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.relational;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameImpl;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.dialect.Dialect;

public interface SqlStringGenerationContext {
    public Dialect getDialect();

    public Identifier toIdentifier(String var1);

    public Identifier getDefaultCatalog();

    default public Identifier catalogWithDefault(Identifier explicitCatalogOrNull) {
        return explicitCatalogOrNull != null ? explicitCatalogOrNull : this.getDefaultCatalog();
    }

    public Identifier getDefaultSchema();

    default public Identifier schemaWithDefault(Identifier explicitSchemaOrNull) {
        return explicitSchemaOrNull != null ? explicitSchemaOrNull : this.getDefaultSchema();
    }

    public String format(QualifiedTableName var1);

    public String format(QualifiedSequenceName var1);

    public String format(QualifiedName var1);

    public String formatWithoutCatalog(QualifiedSequenceName var1);

    public boolean isMigration();

    default public QualifiedTableName withDefaults(QualifiedTableName name) {
        if (name.getCatalogName() == null && this.getDefaultCatalog() != null || name.getSchemaName() == null && this.getDefaultSchema() != null) {
            return new QualifiedTableName(this.catalogWithDefault(name.getCatalogName()), this.schemaWithDefault(name.getSchemaName()), name.getTableName());
        }
        return name;
    }

    default public QualifiedSequenceName withDefaults(QualifiedSequenceName name) {
        if (name.getCatalogName() == null && this.getDefaultCatalog() != null || name.getSchemaName() == null && this.getDefaultSchema() != null) {
            return new QualifiedSequenceName(this.catalogWithDefault(name.getCatalogName()), this.schemaWithDefault(name.getSchemaName()), name.getSequenceName());
        }
        return name;
    }

    default public QualifiedName withDefaults(QualifiedName name) {
        if (name.getCatalogName() == null && this.getDefaultCatalog() != null || name.getSchemaName() == null && this.getDefaultSchema() != null) {
            return new QualifiedNameImpl(this.catalogWithDefault(name.getCatalogName()), this.schemaWithDefault(name.getSchemaName()), name.getObjectName());
        }
        return name;
    }
}

