/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement.core;

import liquibase.change.ColumnConfig;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.core.DatabaseTableIdentifier;
import liquibase.util.StringUtil;
import lombok.Generated;

public class AddUniqueConstraintStatement
extends AbstractSqlStatement {
    private final ColumnConfig[] columns;
    private final String constraintName;
    private String tablespace;
    private boolean clustered;
    private boolean shouldValidate = true;
    private boolean deferrable;
    private boolean initiallyDeferred;
    private boolean disabled;
    private String forIndexName;
    private String forIndexSchemaName;
    private String forIndexCatalogName;
    private DatabaseTableIdentifier databaseTableIdentifier = new DatabaseTableIdentifier(null, null, null);

    public AddUniqueConstraintStatement(String catalogName, String schemaName, String tableName, ColumnConfig[] columns, String constraintName) {
        this.databaseTableIdentifier.setCatalogName(catalogName);
        this.databaseTableIdentifier.setSchemaName(schemaName);
        this.databaseTableIdentifier.setTableName(tableName);
        this.columns = columns;
        this.constraintName = constraintName;
    }

    public String getColumnNames() {
        return StringUtil.join(this.columns, ", ", obj -> obj.getName() + (obj.getDescending() != null && obj.getDescending() != false ? " DESC" : ""));
    }

    public AddUniqueConstraintStatement setTablespace(String tablespace) {
        this.tablespace = tablespace;
        return this;
    }

    public AddUniqueConstraintStatement setDeferrable(boolean deferrable) {
        this.deferrable = deferrable;
        return this;
    }

    public AddUniqueConstraintStatement setInitiallyDeferred(boolean initiallyDeferred) {
        this.initiallyDeferred = initiallyDeferred;
        return this;
    }

    public AddUniqueConstraintStatement setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public AddUniqueConstraintStatement setClustered(boolean clustered) {
        this.clustered = clustered;
        return this;
    }

    public boolean shouldValidate() {
        return this.shouldValidate;
    }

    public AddUniqueConstraintStatement setShouldValidate(boolean shouldValidate) {
        this.shouldValidate = shouldValidate;
        return this;
    }

    public String getTableName() {
        return this.databaseTableIdentifier.getTableName();
    }

    public String getSchemaName() {
        return this.databaseTableIdentifier.getSchemaName();
    }

    public String getCatalogName() {
        return this.databaseTableIdentifier.getCatalogName();
    }

    @Generated
    public ColumnConfig[] getColumns() {
        return this.columns;
    }

    @Generated
    public String getConstraintName() {
        return this.constraintName;
    }

    @Generated
    public String getTablespace() {
        return this.tablespace;
    }

    @Generated
    public boolean isClustered() {
        return this.clustered;
    }

    @Generated
    public boolean isDeferrable() {
        return this.deferrable;
    }

    @Generated
    public boolean isInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public String getForIndexName() {
        return this.forIndexName;
    }

    @Generated
    public void setForIndexName(String forIndexName) {
        this.forIndexName = forIndexName;
    }

    @Generated
    public String getForIndexSchemaName() {
        return this.forIndexSchemaName;
    }

    @Generated
    public void setForIndexSchemaName(String forIndexSchemaName) {
        this.forIndexSchemaName = forIndexSchemaName;
    }

    @Generated
    public String getForIndexCatalogName() {
        return this.forIndexCatalogName;
    }

    @Generated
    public void setForIndexCatalogName(String forIndexCatalogName) {
        this.forIndexCatalogName = forIndexCatalogName;
    }
}

