/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.os;

import io.smallrye.common.os.GetAllProcessesInfoAction;
import io.smallrye.common.os.ProcessInfo;
import java.security.AccessController;
import java.util.List;

public final class Process {
    private static final ProcessHandle current = AccessController.doPrivileged(ProcessHandle::current);
    private static final ProcessHandle.Info currentInfo = current.info();
    private static final String name = AccessController.doPrivileged(Process::computeProcessName);

    private Process() {
    }

    public static String getProcessName() {
        return name;
    }

    private static String computeProcessName() {
        String processName = System.getProperty("jboss.process.name");
        if (processName == null) {
            processName = currentInfo.command().orElse(null);
        }
        if (processName == null) {
            processName = "<unknown>";
        }
        return processName;
    }

    @Deprecated(since="2.4", forRemoval=true)
    public static long getProcessId() {
        return current.pid();
    }

    @Deprecated(since="2.4", forRemoval=true)
    public static ProcessInfo getCurrentProcess() {
        return new ProcessInfo(current.pid(), Process.getProcessName());
    }

    @Deprecated(since="2.4", forRemoval=true)
    public static List<ProcessInfo> getAllProcesses() {
        return AccessController.doPrivileged(new GetAllProcessesInfoAction());
    }
}

