/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayRemoveIndexUnnestFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;

public class GaussDBArrayRemoveIndexFunction
extends ArrayRemoveIndexUnnestFunction {
    private final boolean castEmptyArrayLiteral;

    public GaussDBArrayRemoveIndexFunction(boolean castEmptyArrayLiteral) {
        super(castEmptyArrayLiteral);
        this.castEmptyArrayLiteral = castEmptyArrayLiteral;
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression indexExpression = (Expression)sqlAstArguments.get(1);
        sqlAppender.append((CharSequence)"case when ");
        arrayExpression.accept(walker);
        sqlAppender.append((CharSequence)" IS NOT NULL THEN COALESCE((SELECT array_agg(");
        arrayExpression.accept(walker);
        sqlAppender.append((CharSequence)"[idx]) FROM generate_subscripts(");
        arrayExpression.accept(walker);
        sqlAppender.append((CharSequence)", 1) AS idx ");
        if (indexExpression instanceof Literal) {
            Literal literal = (Literal)indexExpression;
            Object literalValue = literal.getLiteralValue();
            if (literalValue != null) {
                GaussDBArrayRemoveIndexFunction.appendWhere(sqlAppender, walker, indexExpression);
            }
        } else {
            GaussDBArrayRemoveIndexFunction.appendWhere(sqlAppender, walker, indexExpression);
        }
        sqlAppender.append((CharSequence)"), CAST(ARRAY[] AS VARCHAR ARRAY)) ");
        if (this.castEmptyArrayLiteral) {
            sqlAppender.append((CharSequence)"ELSE CAST(ARRAY[] AS VARCHAR ARRAY) ");
        }
        sqlAppender.append((CharSequence)"END AS result_array");
    }

    private static void appendWhere(SqlAppender sqlAppender, SqlAstTranslator<?> walker, Expression indexExpression) {
        sqlAppender.append((CharSequence)"where idx not in (");
        indexExpression.accept(walker);
        sqlAppender.append((CharSequence)")");
    }
}

