/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.core;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.vertx.core.ContextAwareExecutorWrapper;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.Vertx;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;

public interface ContextAwareScheduler {
    @CheckReturnValue
    public static ContextCaptureStrategy delegatingTo(ScheduledExecutorService delegate) {
        Objects.requireNonNull(delegate, "The delegate executor cannot be null");
        return new ContextCaptureStrategy(delegate);
    }

    public static final class ContextCaptureStrategy {
        private final ScheduledExecutorService delegate;

        private ContextCaptureStrategy(ScheduledExecutorService delegate) {
            this.delegate = delegate;
        }

        public ScheduledExecutorService withContext(Context context) {
            Objects.requireNonNull(context, "The context cannot be null");
            return new ContextAwareExecutorWrapper(this.delegate, () -> context);
        }

        public ScheduledExecutorService withGetOrCreateContext(Vertx vertx) {
            Objects.requireNonNull(vertx, "The Vertx object cannot be null");
            return new ContextAwareExecutorWrapper(this.delegate, vertx::getOrCreateContext);
        }

        public ScheduledExecutorService withGetOrCreateContextOnCurrentThread(Vertx vertx) {
            Objects.requireNonNull(vertx, "The Vertx object cannot be null");
            return this.withContext(vertx.getOrCreateContext());
        }

        public ScheduledExecutorService withCurrentContext() throws IllegalStateException {
            return this.withContext(ContextCaptureStrategy.captureCurrentContextOrFail());
        }

        private static Context captureCurrentContextOrFail() throws IllegalStateException {
            Context context = Vertx.currentContext();
            if (context == null) {
                throw new IllegalStateException("There is no Vert.x context in the current thread: " + String.valueOf(Thread.currentThread()));
            }
            return context;
        }
    }
}

