# SPDX-License-Identifier: LGPL-2.1-or-later

complete -c mkosi -f
complete -c mkosi -n '__fish_is_first_token' -a "build clean summary cat-config shell boot vm qemu ssh serve bump help genkey documentation journalctl coredumpctl burn dependencies completion sysupdate sandbox"
complete -c mkosi -s f -l force -d "Remove existing image file before operation" -f
complete -c mkosi -s C -l directory -d "Change to specified directory before doing anything" --force-files -a '(__fish_complete_directories)'
complete -c mkosi -l debug -d "Turn on debugging output" -f
complete -c mkosi -l debug-shell -d "Spawn an interactive shell in the image if a chroot command fails" -f
complete -c mkosi -l debug-workspace -d "When an error occurs, the workspace directory will not be deleted" -f
complete -c mkosi -l debug-sandbox -d "Run mkosi-sandbox with strace" -f
complete -c mkosi -l no-pager -d "Enable paging for long output" -f
complete -c mkosi -l genkey-valid-days -d "Number of days keys should be valid when generating keys" -f
complete -c mkosi -l genkey-common-name -d "Template for the CN when generating keys" -f
complete -c mkosi -s B -l auto-bump -d "Automatically bump image version after building" -f
complete -c mkosi -l doc-format -a "auto markdown man pandoc system" -d "The format to show documentation in" -f
complete -c mkosi -l json -d "Show summary as JSON" -f
complete -c mkosi -s w -l wipe-build-dir -d "Remove the build directory before building the image" -f
complete -c mkosi -s I -l include -r -d "Include configuration from the specified file or directory" -f
complete -c mkosi -l profile -r -d "Build the specified profiles" -f
complete -c mkosi -l dependency -r -d "Specify other images that this image depends on" -f
complete -c mkosi -l minimum-version -r -d "Specify the minimum required mkosi version" -f
complete -c mkosi -l configure-script -r -d "Configure script to run before doing anything" -f
complete -c mkosi -l pass-environment -r -d "Environment variables to pass to subimages" -f
complete -c mkosi -s d -l distribution -r -a "fedora debian kali ubuntu arch opensuse mageia centos rhel rhel-ubi openmandriva rocky alma azure custom " -d "Distribution to install" -f
complete -c mkosi -s r -l release -r -d "Distribution release to install" -f
complete -c mkosi -l architecture -r -a "alpha arc arm arm64 ia64 loongarch64 mips-le mips64-le parisc ppc ppc64 ppc64-le riscv32 riscv64 s390 s390x tilegx x86 x86-64 " -d "Override the architecture of installation" -f
complete -c mkosi -s m -l mirror -r -d "Distribution mirror to use" -f
complete -c mkosi -l local-mirror -r -d "Use a single local, flat and plain mirror to build the image" -f
complete -c mkosi -l repository-key-check -d "Controls signature and key checks on repositories" -f
complete -c mkosi -l repository-key-fetch -d "Controls whether distribution GPG keys can be fetched remotely" -f
complete -c mkosi -l repositories -r -d "Repositories to use" -f
complete -c mkosi -s t -l format -r -a "confext cpio directory disk esp none portable sysext tar uki oci addon " -d "Output Format" -f
complete -c mkosi -l manifest-format -r -d "Manifest Format" -f
complete -c mkosi -s o -l output -r -d "Output name" -f
complete -c mkosi -l compress-output -d "Enable whole-output compression (with images or archives)" -f
complete -c mkosi -l compress-level -r -d "Set the compression level to use" -f
complete -c mkosi -s O -l output-directory -r -d "Output directory" -f
complete -c mkosi -l output-mode -r -d "Set file system access mode for image" -f
complete -c mkosi -l image-version -r -d "Set version for image" -f
complete -c mkosi -l image-id -r -d "Set ID for image" -f
complete -c mkosi -l split-artifacts -d "Split artifacts out of the final image" -f
complete -c mkosi -l repart-directory -r -d "Directory containing systemd-repart partition definitions" -f
complete -c mkosi -l sector-size -r -d "Set the disk image sector size" -f
complete -c mkosi -l overlay -d "Only output the additions on top of the given base trees" -f
complete -c mkosi -l seed -r -d "Set the seed for systemd-repart" -f
complete -c mkosi -l clean-script -r -d "Clean script to run after cleanup" -f
complete -c mkosi -s p -l package -r -d "Add an additional package to the OS image" -f
complete -c mkosi -l build-package -r -d "Additional packages needed for build scripts" -f
complete -c mkosi -l volatile-package -r -d "Packages to install after executing build scripts" -f
complete -c mkosi -l package-directory -r -d "Specify a directory containing extra packages" -f
complete -c mkosi -l volatile-package-directory -r -d "Specify a directory containing extra volatile packages" -f
complete -c mkosi -l with-recommends -d "Install recommended packages" -f
complete -c mkosi -l with-docs -d "Install documentation" -f
complete -c mkosi -l base-tree -r -d "Use the given tree as base tree (e.g. lower sysext layer)" -f
complete -c mkosi -l skeleton-tree -r -d "Use a skeleton tree to bootstrap the image before installing anything" -f
complete -c mkosi -l extra-tree -r -d "Copy an extra tree on top of image" -f
complete -c mkosi -l remove-package -r -d "Remove package from the image OS image after installation" -f
complete -c mkosi -l remove-files -r -d "Remove files from built image" -f
complete -c mkosi -l clean-package-metadata -r -d "Remove package manager database and other files" -f
complete -c mkosi -l source-date-epoch -r -d "Set the $SOURCE_DATE_EPOCH timestamp" -f
complete -c mkosi -l sync-script -r -d "Sync script to run before starting the build" -f
complete -c mkosi -l prepare-script -r -d "Prepare script to run inside the image before it is cached" -f
complete -c mkosi -l build-script -r -d "Build script to run inside image" -f
complete -c mkosi -l postinst-script -r -d "Postinstall script to run inside image" -f
complete -c mkosi -l finalize-script -r -d "Postinstall script to run outside image" -f
complete -c mkosi -l postoutput-script -r -d "Output postprocessing script to run outside image" -f
complete -c mkosi -l bootable -d "Generate ESP partition with systemd-boot and UKIs for installed kernels" -f
complete -c mkosi -l bootloader -r -a "none uki systemd-boot grub uki-signed systemd-boot-signed grub-signed " -d "Specify which UEFI bootloader to use" -f
complete -c mkosi -l bios-bootloader -r -a "none grub " -d "Specify which BIOS bootloader to use" -f
complete -c mkosi -l shim-bootloader -r -a "none signed unsigned " -d "Specify whether to use shim" -f
complete -c mkosi -l unified-kernel-images -r -d "Specify whether to use UKIs with grub/systemd-boot in UEFI mode" -f
complete -c mkosi -l unified-kernel-image-format -r -d "Specify the format used for the UKI filename" -f
complete -c mkosi -l uki-profile -r -d "Configuration files to generate UKI profiles" -f
complete -c mkosi -l initrd -r -d "Add a user-provided initrd to image" -f
complete -c mkosi -l microcode-host -d "Only include the host CPU\'s microcode" -f
complete -c mkosi -l initrd-package -r -d "Add additional packages to the default initrd" -f
complete -c mkosi -l initrd-volatile-package -r -d "Packages to install in the initrd that are not cached" -f
complete -c mkosi -l devicetree -r -d "Devicetree to be used by the booting kernel" -f
complete -c mkosi -l kernel-command-line -r -d "Set the kernel command line (only bootable images)" -f
complete -c mkosi -l kernel-modules-include -r -d "Include the specified kernel modules in the image" -f
complete -c mkosi -l kernel-modules-include-host -r -d "Include the currently loaded modules on the host in the image" -f
complete -c mkosi -l kernel-modules-exclude -r -d "Exclude the specified kernel modules from the image" -f
complete -c mkosi -l kernel-modules-initrd -d "When building a bootable image, add an extra initrd containing the kernel modules" -f
complete -c mkosi -l kernel-modules-initrd-include -r -d "When building a kernel modules initrd, include the specified kernel modules" -f
complete -c mkosi -l kernel-modules-initrd-include-host -r -d "When building a kernel modules initrd, include the currently loaded modules on the host in the image" -f
complete -c mkosi -l kernel-modules-initrd-exclude -r -d "When building a kernel modules initrd, exclude the specified kernel modules" -f
complete -c mkosi -l locale -r -d "Set the system locale" -f
complete -c mkosi -l locale-messages -r -d "Set the messages locale" -f
complete -c mkosi -l keymap -r -d "Set the system keymap" -f
complete -c mkosi -l timezone -r -d "Set the system timezone" -f
complete -c mkosi -l hostname -r -d "Set the system hostname" -f
complete -c mkosi -l root-password -r -d "Set the password for root" -f
complete -c mkosi -l root-shell -r -d "Set the shell for root" -f
complete -c mkosi -l machine-id -r -d "Set the machine ID to use" -f
complete -c mkosi -s a -l autologin -d "Enable root autologin" -f
complete -c mkosi -l make-initrd -d "Make sure the image can be used as an initramfs" -f
complete -c mkosi -l ssh -d "Set up SSH access from the host to the final image via \'mkosi ssh\'" -f
complete -c mkosi -l selinux-relabel -r -d "Specify whether to relabel all files with setfiles" -f
complete -c mkosi -l secure-boot -d "Sign the resulting kernel/initrd image for UEFI SecureBoot" -f
complete -c mkosi -l secure-boot-auto-enroll -r -d "Automatically enroll the secureboot signing key on first boot" -f
complete -c mkosi -l secure-boot-key -r -d "UEFI SecureBoot private key" -f
complete -c mkosi -l secure-boot-key-source -r -d "The source to use to retrieve the secure boot signing key" -f
complete -c mkosi -l secure-boot-certificate -r -d "UEFI SecureBoot certificate in X509 format" -f
complete -c mkosi -l secure-boot-certificate-source -r -d "The source to use to retrieve the secure boot signing certificate" -f
complete -c mkosi -l secure-boot-sign-tool -r -a "auto sbsign systemd-sbsign " -d "Tool to use for signing PE binaries for secure boot" -f
complete -c mkosi -l verity -r -d "Configure whether to enforce or disable verity partitions for disk images" -f
complete -c mkosi -l verity-key -r -d "Private key for signing verity signature" -f
complete -c mkosi -l verity-key-source -r -d "The source to use to retrieve the verity signing key" -f
complete -c mkosi -l verity-certificate -r -d "Certificate for signing verity signature in X509 format" -f
complete -c mkosi -l verity-certificate-source -r -d "The source to use to retrieve the verity signing certificate" -f
complete -c mkosi -l sign-expected-pcr -r -d "Measure the components of the unified kernel image (UKI) and embed the PCR signature into the UKI" -f
complete -c mkosi -l sign-expected-pcr-key -r -d "Private key for signing expected PCR signature" -f
complete -c mkosi -l sign-expected-pcr-key-source -r -d "The source to use to retrieve the expected PCR signing key" -f
complete -c mkosi -l sign-expected-pcr-certificate -r -d "Certificate for signing expected PCR signature in X509 format" -f
complete -c mkosi -l sign-expected-pcr-certificate-source -r -d "The source to use to retrieve the expected PCR signing certificate" -f
complete -c mkosi -l passphrase -r -d "Path to a file containing the passphrase to use when LUKS encryption is selected" -f
complete -c mkosi -l checksum -d "Write SHA256SUMS file" -f
complete -c mkosi -l sign -d "Write and sign SHA256SUMS file" -f
complete -c mkosi -l key -r -d "GPG key to use for signing" -f
complete -c mkosi -l openpgp-tool -r -d "OpenPGP implementation to use for signing" -f
complete -c mkosi -l tools-tree -d "Look up programs to execute inside the given tree" -f
complete -c mkosi -l tools-tree-distribution -r -a "fedora debian kali ubuntu arch opensuse mageia centos rhel rhel-ubi openmandriva rocky alma azure custom " -d "Set the distribution to use for the default tools tree" -f
complete -c mkosi -l tools-tree-release -r -d "Set the release to use for the default tools tree" -f
complete -c mkosi -l tools-tree-mirror -r -d "Set the mirror to use for the default tools tree" -f
complete -c mkosi -l tools-tree-repository -r -d "Repositories to use for the default tools tree" -f
complete -c mkosi -l tools-tree-sandbox-tree -r -d "Sandbox trees for the default tools tree" -f
complete -c mkosi -l tools-tree-package -r -d "Add additional packages to the default tools tree" -f
complete -c mkosi -l tools-tree-package-directory -r -d "Specify a directory containing extra tools tree packages" -f
complete -c mkosi -l tools-tree-certificates -r -d "Use certificates from the tools tree" -f
complete -c mkosi -l extra-search-path -r -d "List of comma-separated paths to look for programs before looking in PATH" -f
complete -c mkosi -s i -l incremental -a "yes no strict" -d "Make use of and generate intermediary cache images" -f
complete -c mkosi -l cache-only -r -a "always auto none metadata never " -d "Only use the package cache when installing packages" -f
complete -c mkosi -l sandbox-tree -r -d "Use a sandbox tree to configure the various tools that mkosi executes" -f
complete -c mkosi -l workspace-directory -r -d "Workspace directory" -f
complete -c mkosi -l cache-directory -r -d "Incremental cache directory" -f
complete -c mkosi -l package-cache-directory -r -d "Package cache directory" -f
complete -c mkosi -l build-directory -r -d "Path to use as persistent build directory" -f
complete -c mkosi -l use-subvolumes -d "Use btrfs subvolumes for faster directory operations where possible" -f
complete -c mkosi -l repart-offline -r -d "Build disk images without using loopback devices" -f
complete -c mkosi -l history -r -d "Whether mkosi can store information about previous builds" -f
complete -c mkosi -l build-sources -r -d "Path for sources to build" -f
complete -c mkosi -l build-sources-ephemeral -a "yes no buildcache" -d "Make build sources ephemeral when running scripts" -f
complete -c mkosi -s E -l environment -r -d "Set an environment variable when running scripts" -f
complete -c mkosi -l env-file -r -d "Environment files to set when running scripts" -f
complete -c mkosi -s T -l without-tests -d "Do not run tests as part of build scripts, if supported" -f
complete -c mkosi -l with-network -d "Run build and postinst scripts with network access (instead of private network)" -f
complete -c mkosi -l proxy-url -r -d "Set the proxy to use" -f
complete -c mkosi -l proxy-exclude -r -d "Don\'t use the configured proxy for the specified host(s)" -f
complete -c mkosi -l proxy-peer-certificate -r -d "Set the proxy peer certificate" -f
complete -c mkosi -l proxy-client-certificate -r -d "Set the proxy client certificate" -f
complete -c mkosi -l proxy-client-key -r -d "Set the proxy client key" -f
complete -c mkosi -l settings -r -d "Add in .nspawn settings file" -f
complete -c mkosi -l ephemeral -d "If specified, the container/VM is run with a temporary snapshot of the output image that is removed immediately when the container/VM terminates" -f
complete -c mkosi -l credential -r -d "Pass a systemd credential to a systemd-nspawn container or a virtual machine" -f
complete -c mkosi -l kernel-command-line-extra -r -d "Append extra entries to the kernel command line when booting the image" -f
complete -c mkosi -l runtime-tree -r -d "Additional mounts to add when booting the image" -f
complete -c mkosi -l runtime-size -r -d "Grow disk images to the specified size before booting them" -f
complete -c mkosi -l runtime-scratch -r -d "Mount extra scratch space to /var/tmp" -f
complete -c mkosi -l runtime-network -r -a "interface user none " -d "Set networking backend to use when booting the image" -f
complete -c mkosi -l runtime-build-sources -r -d "Mount build sources and build directory in /work when booting the image" -f
complete -c mkosi -l runtime-home -r -d "Mount current home directory to /root when booting the image" -f
complete -c mkosi -l unit-property -r -d "Set properties on the scopes spawned by systemd-nspawn or systemd-run" -f
complete -c mkosi -l ssh-key -r -d "Private key for use with mkosi ssh in PEM format" -f
complete -c mkosi -l ssh-certificate -r -d "Certificate for use with mkosi ssh in X509 format" -f
complete -c mkosi -l vmm -r -a "qemu vmspawn " -d "Set the virtual machine monitor to use for mkosi vm" -f
complete -c mkosi -l machine -r -d "Set the machine name to use when booting the image" -f
complete -c mkosi -l forward-journal -r -d "Set the path used to store forwarded machine journals" -f
complete -c mkosi -l sysupdate-directory -r -d "Directory containing systemd-sysupdate transfer definitions" -f
complete -c mkosi -l console -d "Configure the virtual machine console mode to use" -f
complete -c mkosi -l cpus -r -d "Configure number of CPUs in virtual machine" -f
complete -c mkosi -l ram -r -d "Configure guest\'s RAM size" -f
complete -c mkosi -l kvm -d "Configure whether to use KVM or not" -f
complete -c mkosi -l vsock -d "Configure whether to use vsock or not" -f
complete -c mkosi -l vsock-cid -r -d "Specify the vsock connection ID to use" -f
complete -c mkosi -l tpm -d "Configure whether to use a virtual tpm or not" -f
complete -c mkosi -l cdrom -d "Attach the image as a CD-ROM to the virtual machine" -f
complete -c mkosi -l removable -d "Attach the image as a removable drive to the virtual machine" -f
complete -c mkosi -l firmware -r -a "auto linux uefi uefi-secure-boot bios " -d "Select the virtual machine firmware to use" -f
complete -c mkosi -l firmware-variables -r -d "Set the path to the firmware variables file to use" -f
complete -c mkosi -l linux -r -d "Specify the kernel to use for direct kernel boot" -f
complete -c mkosi -l drive -r -d "Specify drive that mkosi should create and pass to the virtual machine" -f
complete -c mkosi -l qemu-args -r -d "==SUPPRESS==" -f
complete -c mkosi -l register -r -d "Register booted vm/container with systemd-machined" -f

