"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultBannerSettings = void 0;
var _configSchema = require("@osd/config-schema");
var _i18n = require("@osd/i18n");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const getDefaultBannerSettings = () => {
  return {
    'banner:active': {
      name: _i18n.i18n.translate('banner.ui_settings.params.visibleTitle', {
        defaultMessage: 'Banner visibility'
      }),
      value: true,
      type: 'boolean',
      description: _i18n.i18n.translate('banner.ui_settings.params.visibleText', {
        defaultMessage: 'Controls whether the global banner is visible.'
      }),
      category: ['banner'],
      schema: _configSchema.schema.boolean(),
      requiresPageReload: true
    },
    'banner:content': {
      name: _i18n.i18n.translate('banner.ui_settings.params.contentTitle', {
        defaultMessage: 'Banner content'
      }),
      value: '',
      type: 'markdown',
      description: _i18n.i18n.translate('banner.ui_settings.params.contentText', {
        defaultMessage: 'Content for the global banner displayed at the top of the page. {markdownLink}.',
        description: 'Part of composite text: banner.ui_settings.params.contentText + ' + 'banner.ui_settings.params.content.markdownLinkText',
        values: {
          markdownLink: `<a href="https://help.github.com/articles/basic-writing-and-formatting-syntax/"
            target="_blank" rel="noopener noreferrer">` + _i18n.i18n.translate('banner.ui_settings.params.content.markdownLinkText', {
            defaultMessage: 'Markdown supported'
          }) + '</a>'
        }
      }),
      category: ['banner'],
      schema: _configSchema.schema.string(),
      requiresPageReload: true
    },
    'banner:color': {
      name: _i18n.i18n.translate('banner.ui_settings.params.colorTitle', {
        defaultMessage: 'Banner color'
      }),
      value: 'primary',
      type: 'select',
      options: ['primary', 'warning', 'danger'],
      description: _i18n.i18n.translate('banner.ui_settings.params.colorText', {
        defaultMessage: 'Color scheme for the global banner.'
      }),
      category: ['banner'],
      schema: _configSchema.schema.oneOf([_configSchema.schema.literal('primary'), _configSchema.schema.literal('warning'), _configSchema.schema.literal('danger')]),
      requiresPageReload: true
    },
    'banner:iconType': {
      name: _i18n.i18n.translate('banner.ui_settings.params.iconTypeTitle', {
        defaultMessage: 'Banner icon'
      }),
      value: 'iInCircle',
      type: 'select',
      options: ['iInCircle', 'help', 'alert', 'warning', 'check', 'bell'],
      description: _i18n.i18n.translate('banner.ui_settings.params.iconTypeText', {
        defaultMessage: 'Icon to display in the global banner.'
      }),
      category: ['banner'],
      schema: _configSchema.schema.oneOf([_configSchema.schema.literal('iInCircle'), _configSchema.schema.literal('help'), _configSchema.schema.literal('alert'), _configSchema.schema.literal('warning'), _configSchema.schema.literal('bell')]),
      requiresPageReload: true
    },
    'banner:useMarkdown': {
      name: _i18n.i18n.translate('banner.ui_settings.params.useMarkdownTitle', {
        defaultMessage: 'Use markdown in banner'
      }),
      value: true,
      type: 'boolean',
      description: _i18n.i18n.translate('banner.ui_settings.params.useMarkdownText', {
        defaultMessage: 'Controls whether markdown is rendered in the banner content.'
      }),
      category: ['banner'],
      schema: _configSchema.schema.boolean(),
      requiresPageReload: true
    }
  };
};
exports.getDefaultBannerSettings = getDefaultBannerSettings;