"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlToDatasourceType = exports.QUERY_RESTRICTED = exports.QUERY_ALL = exports.PrometheusURL = exports.OPENSEARCH_S3_DOCUMENTATION_URL = exports.OPENSEARCH_DOCUMENTATION_URL = exports.OPENSEARCH_ACC_DOCUMENTATION_URL = exports.DatasourceTypeToDisplayName = exports.AmazonS3URL = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const OPENSEARCH_DOCUMENTATION_URL = exports.OPENSEARCH_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/dashboards/management/data-sources/';
const OPENSEARCH_S3_DOCUMENTATION_URL = exports.OPENSEARCH_S3_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/dashboards/management/S3-data-source/';
const OPENSEARCH_ACC_DOCUMENTATION_URL = exports.OPENSEARCH_ACC_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/dashboards/management/accelerate-external-data/';
const QUERY_RESTRICTED = exports.QUERY_RESTRICTED = 'query-restricted';
const QUERY_ALL = exports.QUERY_ALL = 'query-all';
const DatasourceTypeToDisplayName = exports.DatasourceTypeToDisplayName = {
  PROMETHEUS: 'Prometheus',
  S3GLUE: 'Amazon S3'
};
const PrometheusURL = exports.PrometheusURL = 'Prometheus';
const AmazonS3URL = exports.AmazonS3URL = 'AmazonS3AWSGlue';
const UrlToDatasourceType = exports.UrlToDatasourceType = {
  [PrometheusURL]: 'PROMETHEUS',
  [AmazonS3URL]: 'S3GLUE'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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