/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.geom.GeneralPath;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.afm.AFMParser;
import org.apache.fontbox.afm.FontMetrics;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.UniUtil;
import org.apache.pdfbox.pdmodel.font.encoding.GlyphList;
import org.apache.pdfbox.pdmodel.font.encoding.SymbolEncoding;

public final class Standard14Fonts {
    private static final Map<String, FontName> ALIASES = new HashMap<String, FontName>(38);
    private static final Map<FontName, FontMetrics> FONTS = new EnumMap<FontName, FontMetrics>(FontName.class);
    private static final Map<FontName, FontBoxFont> GENERIC_FONTS = new EnumMap<FontName, FontBoxFont>(FontName.class);

    private Standard14Fonts() {
    }

    private static void loadMetrics(FontName fontName) throws IOException {
        String resourceName = "/org/apache/pdfbox/resources/afm/" + fontName.getName() + ".afm";
        InputStream resourceAsStream = PDType1Font.class.getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            throw new IOException("resource '" + resourceName + "' not found");
        }
        try (BufferedInputStream afmStream = new BufferedInputStream(resourceAsStream);){
            AFMParser parser = new AFMParser((InputStream)afmStream);
            FontMetrics metric = parser.parse(true);
            FONTS.put(fontName, metric);
        }
    }

    private static void mapName(FontName baseName) {
        ALIASES.put(baseName.getName(), baseName);
    }

    private static void mapName(String alias, FontName baseName) {
        ALIASES.put(alias, baseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontMetrics getAFM(String fontName) {
        FontName baseName = ALIASES.get(fontName);
        if (baseName == null) {
            return null;
        }
        if (FONTS.get((Object)baseName) == null) {
            Map<FontName, FontMetrics> map = FONTS;
            synchronized (map) {
                if (FONTS.get((Object)baseName) == null) {
                    try {
                        Standard14Fonts.loadMetrics(baseName);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            }
        }
        return FONTS.get((Object)baseName);
    }

    public static boolean containsName(String fontName) {
        return ALIASES.containsKey(fontName);
    }

    public static Set<String> getNames() {
        return Collections.unmodifiableSet(ALIASES.keySet());
    }

    public static FontName getMappedFontName(String fontName) {
        return ALIASES.get(fontName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FontBoxFont getMappedFont(FontName baseName) {
        if (!GENERIC_FONTS.containsKey((Object)baseName)) {
            Map<FontName, FontBoxFont> map = GENERIC_FONTS;
            synchronized (map) {
                if (!GENERIC_FONTS.containsKey((Object)baseName)) {
                    PDType1Font type1Font = new PDType1Font(baseName);
                    GENERIC_FONTS.put(baseName, type1Font.getFontBoxFont());
                }
            }
        }
        return GENERIC_FONTS.get((Object)baseName);
    }

    public static GeneralPath getGlyphPath(FontName baseName, String glyphName) throws IOException {
        FontBoxFont mappedFont;
        if (!glyphName.equals(".notdef") && (mappedFont = Standard14Fonts.getMappedFont(baseName)) != null) {
            String uniName;
            Integer code;
            String uniName2;
            if (mappedFont.hasGlyph(glyphName)) {
                return mappedFont.getPath(glyphName);
            }
            String unicodes = Standard14Fonts.getGlyphList(baseName).toUnicode(glyphName);
            if (unicodes != null && unicodes.length() == 1 && mappedFont.hasGlyph(uniName2 = UniUtil.getUniNameOfCodePoint(unicodes.codePointAt(0)))) {
                return mappedFont.getPath(uniName2);
            }
            if ("SymbolMT".equals(mappedFont.getName()) && (code = SymbolEncoding.INSTANCE.getNameToCodeMap().get(glyphName)) != null && mappedFont.hasGlyph(uniName = UniUtil.getUniNameOfCodePoint(code + 61440))) {
                return mappedFont.getPath(uniName);
            }
        }
        return new GeneralPath();
    }

    private static GlyphList getGlyphList(FontName baseName) {
        return FontName.ZAPF_DINGBATS == baseName ? GlyphList.getZapfDingbats() : GlyphList.getAdobeGlyphList();
    }

    static {
        Standard14Fonts.mapName(FontName.COURIER);
        Standard14Fonts.mapName(FontName.COURIER_BOLD);
        Standard14Fonts.mapName(FontName.COURIER_BOLD_OBLIQUE);
        Standard14Fonts.mapName(FontName.COURIER_OBLIQUE);
        Standard14Fonts.mapName(FontName.HELVETICA);
        Standard14Fonts.mapName(FontName.HELVETICA_BOLD);
        Standard14Fonts.mapName(FontName.HELVETICA_BOLD_OBLIQUE);
        Standard14Fonts.mapName(FontName.HELVETICA_OBLIQUE);
        Standard14Fonts.mapName(FontName.TIMES_ROMAN);
        Standard14Fonts.mapName(FontName.TIMES_BOLD);
        Standard14Fonts.mapName(FontName.TIMES_BOLD_ITALIC);
        Standard14Fonts.mapName(FontName.TIMES_ITALIC);
        Standard14Fonts.mapName(FontName.SYMBOL);
        Standard14Fonts.mapName(FontName.ZAPF_DINGBATS);
        Standard14Fonts.mapName("CourierCourierNew", FontName.COURIER);
        Standard14Fonts.mapName("CourierNew", FontName.COURIER);
        Standard14Fonts.mapName("CourierNew,Italic", FontName.COURIER_OBLIQUE);
        Standard14Fonts.mapName("CourierNew,Bold", FontName.COURIER_BOLD);
        Standard14Fonts.mapName("CourierNew,BoldItalic", FontName.COURIER_BOLD_OBLIQUE);
        Standard14Fonts.mapName("Arial", FontName.HELVETICA);
        Standard14Fonts.mapName("Arial,Italic", FontName.HELVETICA_OBLIQUE);
        Standard14Fonts.mapName("Arial,Bold", FontName.HELVETICA_BOLD);
        Standard14Fonts.mapName("Arial,BoldItalic", FontName.HELVETICA_BOLD_OBLIQUE);
        Standard14Fonts.mapName("TimesNewRoman", FontName.TIMES_ROMAN);
        Standard14Fonts.mapName("TimesNewRoman,Italic", FontName.TIMES_ITALIC);
        Standard14Fonts.mapName("TimesNewRoman,Bold", FontName.TIMES_BOLD);
        Standard14Fonts.mapName("TimesNewRoman,BoldItalic", FontName.TIMES_BOLD_ITALIC);
        Standard14Fonts.mapName("Symbol,Italic", FontName.SYMBOL);
        Standard14Fonts.mapName("Symbol,Bold", FontName.SYMBOL);
        Standard14Fonts.mapName("Symbol,BoldItalic", FontName.SYMBOL);
        Standard14Fonts.mapName("Times", FontName.TIMES_ROMAN);
        Standard14Fonts.mapName("Times,Italic", FontName.TIMES_ITALIC);
        Standard14Fonts.mapName("Times,Bold", FontName.TIMES_BOLD);
        Standard14Fonts.mapName("Times,BoldItalic", FontName.TIMES_BOLD_ITALIC);
        Standard14Fonts.mapName("ArialMT", FontName.HELVETICA);
        Standard14Fonts.mapName("Arial-ItalicMT", FontName.HELVETICA_OBLIQUE);
        Standard14Fonts.mapName("Arial-BoldMT", FontName.HELVETICA_BOLD);
        Standard14Fonts.mapName("Arial-BoldItalicMT", FontName.HELVETICA_BOLD_OBLIQUE);
    }

    public static enum FontName {
        TIMES_ROMAN("Times-Roman"),
        TIMES_BOLD("Times-Bold"),
        TIMES_ITALIC("Times-Italic"),
        TIMES_BOLD_ITALIC("Times-BoldItalic"),
        HELVETICA("Helvetica"),
        HELVETICA_BOLD("Helvetica-Bold"),
        HELVETICA_OBLIQUE("Helvetica-Oblique"),
        HELVETICA_BOLD_OBLIQUE("Helvetica-BoldOblique"),
        COURIER("Courier"),
        COURIER_BOLD("Courier-Bold"),
        COURIER_OBLIQUE("Courier-Oblique"),
        COURIER_BOLD_OBLIQUE("Courier-BoldOblique"),
        SYMBOL("Symbol"),
        ZAPF_DINGBATS("ZapfDingbats");

        private final String name;

        private FontName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

