/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.jobscheduler.spi.StatusHistoryModel;
import org.opensearch.transport.client.Client;

public class JobHistoryService {
    private static final Logger logger = LogManager.getLogger(JobHistoryService.class);
    public static final String JOB_HISTORY_INDEX_NAME = ".job-scheduler-history";
    private final Client client;
    private final ClusterService clusterService;
    static final Map<String, Object> INDEX_SETTINGS = Map.of("index.number_of_shards", 1, "index.auto_expand_replicas", "0-1");

    public JobHistoryService(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
    }

    private String historyMapping() {
        try {
            String line;
            InputStream in = JobHistoryService.class.getResourceAsStream("/mappings/job_scheduler_history.json");
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("History Mapping cannot be read correctly.");
        }
    }

    public boolean historyIndexExist() {
        return this.clusterService.state().routingTable().hasIndex(JOB_HISTORY_INDEX_NAME);
    }

    void createHistoryIndex(ActionListener<Boolean> listener) {
        if (this.historyIndexExist()) {
            listener.onResponse((Object)true);
        } else {
            CreateIndexRequest request = new CreateIndexRequest(JOB_HISTORY_INDEX_NAME).mapping(this.historyMapping(), (MediaType)XContentType.JSON).settings(INDEX_SETTINGS);
            this.client.admin().indices().create(request, ActionListener.wrap(response -> listener.onResponse((Object)response.isAcknowledged()), exception -> {
                if (exception instanceof ResourceAlreadyExistsException || exception.getCause() instanceof ResourceAlreadyExistsException) {
                    listener.onResponse((Object)true);
                } else {
                    listener.onFailure(exception);
                }
            }));
        }
    }

    public void recordJobHistory(String jobIndexName, String jobId, Instant startTime, Instant endTime, Integer status, ActionListener<Boolean> listener) {
        if (jobIndexName == null || jobId == null || startTime == null) {
            listener.onFailure((Exception)new IllegalArgumentException("JobIndexName, JobId, StartTime, and Status cannot be null"));
            return;
        }
        this.createHistoryIndex((ActionListener<Boolean>)ActionListener.wrap(created -> {
            if (created.booleanValue()) {
                this.findHistoryRecord(jobIndexName, jobId, startTime, (ActionListener<StatusHistoryModel>)ActionListener.wrap(existingRecord -> {
                    if (existingRecord != null) {
                        StatusHistoryModel updatedModel = new StatusHistoryModel(jobIndexName, jobId, startTime, endTime, status.intValue(), existingRecord.getSeqNo(), existingRecord.getPrimaryTerm());
                        this.updateHistoryRecord(updatedModel, (ActionListener<StatusHistoryModel>)ActionListener.wrap(updated -> listener.onResponse((Object)(updated != null ? 1 : 0)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                    } else {
                        try {
                            StatusHistoryModel historyModel = new StatusHistoryModel(jobIndexName, jobId, startTime, endTime, status.intValue());
                            this.createHistoryRecord(historyModel, listener);
                        }
                        catch (Exception e) {
                            logger.error("Failed to create history record", (Throwable)e);
                            listener.onFailure(e);
                        }
                    }
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onResponse((Object)false);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void createHistoryRecord(StatusHistoryModel historyModel, ActionListener<Boolean> listener) {
        try {
            String historyId = this.generateHistoryId(historyModel.getJobIndexName(), historyModel.getJobId(), historyModel.getStartTime());
            IndexRequest request = ((IndexRequest)new IndexRequest(JOB_HISTORY_INDEX_NAME).id(historyId).source(historyModel.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setIfSeqNo(-2L).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).create(true);
            this.client.index(request, ActionListener.wrap(response -> {
                logger.debug("Successfully recorded job history: {}", (Object)historyModel);
                listener.onResponse((Object)true);
            }, exception -> {
                if (exception instanceof VersionConflictEngineException) {
                    logger.debug("History record already exists: {}", (Object)exception.getMessage());
                }
                listener.onFailure(exception);
            }));
        }
        catch (IOException e) {
            logger.error("IOException occurred creating history record", (Throwable)e);
            listener.onFailure((Exception)e);
        }
    }

    public void updateHistoryRecord(StatusHistoryModel historyModelupdate, ActionListener<StatusHistoryModel> listener) {
        try {
            String documentId = this.generateHistoryId(historyModelupdate.getJobIndexName(), historyModelupdate.getJobId(), historyModelupdate.getStartTime());
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(JOB_HISTORY_INDEX_NAME)).id(documentId).setIfSeqNo(historyModelupdate.getSeqNo()).setIfPrimaryTerm(historyModelupdate.getPrimaryTerm()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(historyModelupdate.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).fetchSource(true);
            this.client.update(updateRequest, ActionListener.wrap(response -> listener.onResponse((Object)new StatusHistoryModel(historyModelupdate.getJobIndexName(), historyModelupdate.getJobId(), historyModelupdate.getStartTime(), historyModelupdate.getEndTime(), historyModelupdate.getStatus(), response.getSeqNo(), response.getPrimaryTerm())), exception -> {
                if (exception instanceof VersionConflictEngineException) {
                    logger.debug("Version conflict updating history record: {}", (Object)exception.getMessage());
                }
                listener.onResponse(null);
            }));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    public void findHistoryRecord(String jobIndexName, String jobId, Instant startTime, ActionListener<StatusHistoryModel> listener) {
        String historyId = this.generateHistoryId(jobIndexName, jobId, startTime);
        GetRequest getRequest = new GetRequest(JOB_HISTORY_INDEX_NAME).id(historyId);
        this.client.get(getRequest, ActionListener.wrap(response -> {
            if (!response.isExists()) {
                listener.onResponse(null);
            } else {
                try {
                    XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
                    parser.nextToken();
                    listener.onResponse((Object)StatusHistoryModel.parse((XContentParser)parser, (long)response.getSeqNo(), (long)response.getPrimaryTerm()));
                }
                catch (IOException e) {
                    logger.error("IOException occurred parsing history record", (Throwable)e);
                    listener.onResponse(null);
                }
            }
        }, exception -> {
            if (exception.getMessage() != null && exception.getMessage().contains("no such index")) {
                listener.onResponse(null);
            } else {
                listener.onFailure(exception);
            }
        }));
    }

    private String generateHistoryId(String jobIndexName, String jobId, Instant startTime) {
        return jobIndexName + "-" + jobId + "-" + startTime.getEpochSecond();
    }
}

