/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.aws;

import java.time.Clock;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.transport.TransportOptions;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public interface AwsSdk2TransportOptions
extends TransportOptions {
    public AwsCredentialsProvider credentials();

    public Integer requestCompressionSize();

    public Boolean responseCompression();

    public JsonpMapper mapper();

    public Clock signingClock();

    @Override
    public Builder toBuilder();

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static class BuilderImpl
    extends TransportOptions.BuilderImpl
    implements Builder {
        protected AwsCredentialsProvider credentials;
        protected Integer requestCompressionSize;
        protected Boolean responseCompression;
        protected JsonpMapper mapper;
        protected Clock signingClock;

        public BuilderImpl() {
        }

        public BuilderImpl(AwsSdk2TransportOptions src) {
            super(src);
            this.credentials = src.credentials();
            this.requestCompressionSize = src.requestCompressionSize();
            this.responseCompression = src.responseCompression();
            this.mapper = src.mapper();
            this.signingClock = src.signingClock();
        }

        @Override
        public Builder addHeader(String name, String value) {
            super.addHeader(name, value);
            return this;
        }

        @Override
        public Builder setParameter(String name, String value) {
            super.setParameter(name, value);
            return this;
        }

        @Override
        public Builder onWarnings(Function<List<String>, Boolean> listener) {
            super.onWarnings(listener);
            return this;
        }

        @Override
        public Builder setCredentials(AwsCredentialsProvider credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public Builder setRequestCompressionSize(Integer size) {
            this.requestCompressionSize = size;
            return this;
        }

        @Override
        public Builder setMapper(JsonpMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        @Override
        public Builder setResponseCompression(Boolean enabled) {
            this.responseCompression = enabled;
            return this;
        }

        @Override
        public Builder setSigningClock(Clock clock) {
            this.signingClock = clock;
            return this;
        }

        @Override
        public AwsSdk2TransportOptions build() {
            return new DefaultImpl(this);
        }
    }

    public static interface Builder
    extends TransportOptions.Builder {
        @Override
        public Builder addHeader(String var1, String var2);

        @Override
        public Builder setParameter(String var1, String var2);

        @Override
        public Builder onWarnings(Function<List<String>, Boolean> var1);

        public Builder setCredentials(AwsCredentialsProvider var1);

        public Builder setRequestCompressionSize(Integer var1);

        public Builder setResponseCompression(Boolean var1);

        public Builder setMapper(JsonpMapper var1);

        public Builder setSigningClock(Clock var1);

        @Override
        public AwsSdk2TransportOptions build();
    }

    public static class DefaultImpl
    extends TransportOptions.DefaultImpl
    implements AwsSdk2TransportOptions {
        private final AwsCredentialsProvider credentials;
        private final Integer requestCompressionSize;
        private final Boolean responseCompression;
        private final JsonpMapper mapper;
        private final Clock signingClock;

        DefaultImpl(BuilderImpl builder) {
            super(builder);
            this.credentials = builder.credentials;
            this.requestCompressionSize = builder.requestCompressionSize;
            this.responseCompression = builder.responseCompression;
            this.mapper = builder.mapper;
            this.signingClock = builder.signingClock;
        }

        @Override
        public AwsCredentialsProvider credentials() {
            return this.credentials;
        }

        @Override
        public Integer requestCompressionSize() {
            return this.requestCompressionSize;
        }

        @Override
        public Boolean responseCompression() {
            return this.responseCompression;
        }

        @Override
        public JsonpMapper mapper() {
            return this.mapper;
        }

        @Override
        public Clock signingClock() {
            return this.signingClock;
        }

        @Override
        public Builder toBuilder() {
            return new BuilderImpl(this);
        }
    }
}

