/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Retries
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Retries> {
    private final long bulk;
    private final long search;
    public static final JsonpDeserializer<Retries> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Retries::setupRetriesDeserializer);

    private Retries(Builder builder) {
        this.bulk = ApiTypeHelper.requireNonNull(builder.bulk, this, "bulk");
        this.search = ApiTypeHelper.requireNonNull(builder.search, this, "search");
    }

    public static Retries of(Function<Builder, ObjectBuilder<Retries>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long bulk() {
        return this.bulk;
    }

    public final long search() {
        return this.search;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bulk");
        generator.write(this.bulk);
        generator.writeKey("search");
        generator.write(this.search);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRetriesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bulk, JsonpDeserializer.longDeserializer(), "bulk");
        op.add(Builder::search, JsonpDeserializer.longDeserializer(), "search");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.bulk);
        result = 31 * result + Long.hashCode(this.search);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Retries other = (Retries)o;
        return this.bulk == other.bulk && this.search == other.search;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Retries> {
        private Long bulk;
        private Long search;

        public Builder() {
        }

        private Builder(Retries o) {
            this.bulk = o.bulk;
            this.search = o.search;
        }

        private Builder(Builder o) {
            this.bulk = o.bulk;
            this.search = o.search;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder bulk(long value) {
            this.bulk = value;
            return this;
        }

        @Nonnull
        public final Builder search(long value) {
            this.search = value;
            return this;
        }

        @Override
        @Nonnull
        public Retries build() {
            this._checkSingleUse();
            return new Retries(this);
        }
    }
}

