/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.nodes.NodesUsageResponse;
import org.opensearch.client.opensearch.nodes.usage.NodesUsageMetric;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class NodesUsageRequest
extends RequestBase
implements ToCopyableBuilder<Builder, NodesUsageRequest> {
    @Nonnull
    private final List<NodesUsageMetric> metric;
    @Nonnull
    private final List<String> nodeId;
    @Nullable
    private final Time timeout;
    public static final Endpoint<NodesUsageRequest, NodesUsageResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<NodesUsageRequest, NodesUsageResponse>(request -> "GET", request -> {
        boolean _metric = true;
        int _nodeId = 2;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            return "/_nodes/usage";
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/usage/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            buf.append("/usage");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            buf.append("/usage/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, NodesUsageResponse._DESERIALIZER);

    private NodesUsageRequest(Builder builder) {
        super(builder);
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.timeout = builder.timeout;
    }

    public static NodesUsageRequest of(Function<Builder, ObjectBuilder<NodesUsageRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<NodesUsageMetric> metric() {
        return this.metric;
    }

    @Nonnull
    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.metric);
        result = 31 * result + Objects.hashCode(this.nodeId);
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodesUsageRequest other = (NodesUsageRequest)o;
        return Objects.equals(this.metric, other.metric) && Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NodesUsageRequest> {
        @Nullable
        private List<NodesUsageMetric> metric;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(NodesUsageRequest o) {
            super(o);
            this.metric = Builder._listCopy(o.metric);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.metric = Builder._listCopy(o.metric);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder metric(List<NodesUsageMetric> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        @Nonnull
        public final Builder metric(NodesUsageMetric value, NodesUsageMetric ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        @Nonnull
        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        @Nonnull
        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public NodesUsageRequest build() {
            this._checkSingleUse();
            return new NodesUsageRequest(this);
        }
    }
}

