/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.spi.utils;

import inet.ipaddr.HostName;
import inet.ipaddr.IPAddressString;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.opensearch.core.common.Strings;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004\u001a\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0004\u001a\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0004\u001a\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"getResolvedIps", "", "Linet/ipaddr/IPAddressString;", "host", "", "isHostInDenylist", "", "urlString", "hostDenyList", "isValidEmail", "email", "isValidUrl", "validateEmail", "", "validateMethod", "method", "validateUrl", "opensearch-notifications-core-spi"})
@SourceDebugExtension(value={"SMAP\nValidationHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidationHelpers.kt\norg/opensearch/notifications/spi/utils/ValidationHelpersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,121:1\n1#2:122\n11065#3:123\n11400#3,3:124\n*S KotlinDebug\n*F\n+ 1 ValidationHelpers.kt\norg/opensearch/notifications/spi/utils/ValidationHelpersKt\n*L\n58#1:123\n58#1:124,3\n*E\n"})
public final class ValidationHelpersKt {
    public static final void validateUrl(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        if (!(!Strings.isNullOrEmpty((String)urlString))) {
            boolean $i$a$-require-ValidationHelpersKt$validateUrl$32 = false;
            String $i$a$-require-ValidationHelpersKt$validateUrl$32 = "url is null or empty";
            throw new IllegalArgumentException($i$a$-require-ValidationHelpersKt$validateUrl$32.toString());
        }
        if (!ValidationHelpersKt.isValidUrl(urlString)) {
            boolean bl = false;
            String string = "Invalid URL or unsupported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final void validateEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        if (!(!Strings.isNullOrEmpty((String)email))) {
            boolean $i$a$-require-ValidationHelpersKt$validateEmail$32 = false;
            String $i$a$-require-ValidationHelpersKt$validateEmail$32 = "FromAddress and recipient should be provided";
            throw new IllegalArgumentException($i$a$-require-ValidationHelpersKt$validateEmail$32.toString());
        }
        if (!ValidationHelpersKt.isValidEmail(email)) {
            boolean bl = false;
            String string = "Invalid email address";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final boolean isValidUrl(@NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        URL url = new URL(urlString);
        int index = StringsKt.indexOf$default((CharSequence)urlString, (String)"//", (int)0, (boolean)false, (int)6, null) + 2;
        String string = urlString.substring(index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String subString = string;
        Regex regex = new Regex("^(?!.*?_.*?)(?!(?:\\w+?\\.)?-[\\w.\\-]*?)(?!\\w+?-\\.[\\w.\\-]+?)(?=\\w)(?=[\\w.\\-]*?\\.+[\\w.\\-]*?)(?![\\w.\\-]{254})(?!(?:\\.?[\\w\\-.]*?[\\w\\-]{64,}\\.)+?)[\\w.\\-]+?(?<![\\w\\-.]?\\.\\d?)(?<=[\\w\\-]{2,})(?<![\\w\\-]{25})$");
        boolean isFQDN = regex.matches((CharSequence)subString);
        if (isFQDN && !DomainValidator.getInstance().isValid(subString)) {
            return false;
        }
        return Intrinsics.areEqual((Object)subString, (Object)url.getHost()) ? (Intrinsics.areEqual((Object)"https", (Object)url.getProtocol()) || Intrinsics.areEqual((Object)"http", (Object)url.getProtocol())) && isFQDN : (Intrinsics.areEqual((Object)"https", (Object)url.getProtocol()) || Intrinsics.areEqual((Object)"http", (Object)url.getProtocol())) && !isFQDN;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IPAddressString> getResolvedIps(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        try {
            void $this$mapTo$iv$iv;
            InetAddress[] resolvedIps = InetAddress.getAllByName(host);
            Intrinsics.checkNotNull((Object)resolvedIps);
            InetAddress[] $this$map$iv = resolvedIps;
            boolean $i$f$map = false;
            InetAddress[] inetAddressArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void inetAddress;
                void item$iv$iv;
                void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new IPAddressString(inetAddress.getHostAddress()));
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LogManager.getLogger().error("Unable to resolve host ips");
            return CollectionsKt.emptyList();
        }
    }

    public static final boolean isHostInDenylist(@NotNull String urlString, @NotNull List<String> hostDenyList) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter(hostDenyList, (String)"hostDenyList");
        URL url = new URL(urlString);
        if (url.getHost() != null) {
            String string = url.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            List<IPAddressString> resolvedIpStrings = ValidationHelpersKt.getResolvedIps(string);
            HostName hostStr = new HostName(url.getHost());
            for (String network : hostDenyList) {
                IPAddressString denyIpStr = new IPAddressString(network);
                HostName denyHostStr = new HostName(network);
                boolean hostInDenyList = denyHostStr.equals(hostStr);
                boolean ipInDenyList = false;
                for (IPAddressString ipStr : resolvedIpStrings) {
                    if (!denyIpStr.contains(ipStr)) continue;
                    ipInDenyList = true;
                    break;
                }
                if (!hostInDenyList && !ipInDenyList) continue;
                LogManager.getLogger().error(url.getHost() + " is denied");
                return true;
            }
        }
        return false;
    }

    public static final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Regex validEmailPattern = new Regex("(?:[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+\\/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", RegexOption.IGNORE_CASE);
        return validEmailPattern.matches((CharSequence)email);
    }

    public static final void validateMethod(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!(!Strings.isNullOrEmpty((String)method))) {
            boolean bl = false;
            String string = "Method is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new String[]{"POST", "PUT", "PATCH"};
        List validMethods = CollectionsKt.listOf((Object[])objectArray);
        if (!(StringsKt.findAnyOf$default((CharSequence)method, (Collection)validMethods, (int)0, (boolean)false, (int)6, null) != null)) {
            boolean bl = false;
            String string = "Invalid method supplied. Only POST, PUT and PATCH are allowed";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

