/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TopHitsAggregate
extends AggregateBase
implements AggregateVariant,
ToCopyableBuilder<Builder, TopHitsAggregate> {
    @Nonnull
    private final HitsMetadata<JsonData> hits;
    public static final JsonpDeserializer<TopHitsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TopHitsAggregate::setupTopHitsAggregateDeserializer);

    private TopHitsAggregate(Builder builder) {
        super(builder);
        this.hits = ApiTypeHelper.requireNonNull(builder.hits, this, "hits");
    }

    public static TopHitsAggregate of(Function<Builder, ObjectBuilder<TopHitsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.TopHits;
    }

    @Nonnull
    public final HitsMetadata<JsonData> hits() {
        return this.hits;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTopHitsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        TopHitsAggregate.setupAggregateBaseDeserializer(op);
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(JsonData._DESERIALIZER), "hits");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.hits.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopHitsAggregate other = (TopHitsAggregate)o;
        return this.hits.equals(other.hits);
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, TopHitsAggregate> {
        private HitsMetadata<JsonData> hits;

        public Builder() {
        }

        private Builder(TopHitsAggregate o) {
            super(o);
            this.hits = o.hits;
        }

        private Builder(Builder o) {
            super(o);
            this.hits = o.hits;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder hits(HitsMetadata<JsonData> value) {
            this.hits = value;
            return this;
        }

        @Nonnull
        public final Builder hits(Function<HitsMetadata.Builder<JsonData>, ObjectBuilder<HitsMetadata<JsonData>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        @Override
        @Nonnull
        public TopHitsAggregate build() {
            this._checkSingleUse();
            return new TopHitsAggregate(this);
        }
    }
}

