/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.update_aliases;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.indices.update_aliases.Action;
import org.opensearch.client.opensearch.indices.update_aliases.ActionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AddAction
implements ActionVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, AddAction> {
    @Nullable
    private final String alias;
    @Nonnull
    private final List<String> aliases;
    @Nullable
    private final Query filter;
    @Nullable
    private final String index;
    @Nullable
    private final String indexRouting;
    @Nonnull
    private final List<String> indices;
    @Nullable
    private final Boolean isHidden;
    @Nullable
    private final Boolean isWriteIndex;
    @Nullable
    private final Boolean mustExist;
    @Nullable
    private final String routing;
    @Nullable
    private final String searchRouting;
    public static final JsonpDeserializer<AddAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AddAction::setupAddActionDeserializer);

    private AddAction(Builder builder) {
        this.alias = builder.alias;
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.filter = builder.filter;
        this.index = builder.index;
        this.indexRouting = builder.indexRouting;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.isHidden = builder.isHidden;
        this.isWriteIndex = builder.isWriteIndex;
        this.mustExist = builder.mustExist;
        this.routing = builder.routing;
        this.searchRouting = builder.searchRouting;
    }

    public static AddAction of(Function<Builder, ObjectBuilder<AddAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Action.Kind _actionKind() {
        return Action.Kind.Add;
    }

    @Nullable
    public final String alias() {
        return this.alias;
    }

    @Nonnull
    public final List<String> aliases() {
        return this.aliases;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String indexRouting() {
        return this.indexRouting;
    }

    @Nonnull
    public final List<String> indices() {
        return this.indices;
    }

    @Nullable
    public final Boolean isHidden() {
        return this.isHidden;
    }

    @Nullable
    public final Boolean isWriteIndex() {
        return this.isWriteIndex;
    }

    @Nullable
    public final Boolean mustExist() {
        return this.mustExist;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final String searchRouting() {
        return this.searchRouting;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alias != null) {
            generator.writeKey("alias");
            generator.write(this.alias);
        }
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartArray();
            for (String item0 : this.aliases) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.indexRouting != null) {
            generator.writeKey("index_routing");
            generator.write(this.indexRouting);
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.isHidden != null) {
            generator.writeKey("is_hidden");
            generator.write(this.isHidden.booleanValue());
        }
        if (this.isWriteIndex != null) {
            generator.writeKey("is_write_index");
            generator.write(this.isWriteIndex.booleanValue());
        }
        if (this.mustExist != null) {
            generator.writeKey("must_exist");
            generator.write(this.mustExist.booleanValue());
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.searchRouting != null) {
            generator.writeKey("search_routing");
            generator.write(this.searchRouting);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAddActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::alias, JsonpDeserializer.stringDeserializer(), "alias");
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "aliases");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::indexRouting, JsonpDeserializer.stringDeserializer(), "index_routing");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::isHidden, JsonpDeserializer.booleanDeserializer(), "is_hidden");
        op.add(Builder::isWriteIndex, JsonpDeserializer.booleanDeserializer(), "is_write_index");
        op.add(Builder::mustExist, JsonpDeserializer.booleanDeserializer(), "must_exist");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(Builder::searchRouting, JsonpDeserializer.stringDeserializer(), "search_routing");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.alias);
        result = 31 * result + Objects.hashCode(this.aliases);
        result = 31 * result + Objects.hashCode(this.filter);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.indexRouting);
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.isHidden);
        result = 31 * result + Objects.hashCode(this.isWriteIndex);
        result = 31 * result + Objects.hashCode(this.mustExist);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.searchRouting);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddAction other = (AddAction)o;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.aliases, other.aliases) && Objects.equals(this.filter, other.filter) && Objects.equals(this.index, other.index) && Objects.equals(this.indexRouting, other.indexRouting) && Objects.equals(this.indices, other.indices) && Objects.equals(this.isHidden, other.isHidden) && Objects.equals(this.isWriteIndex, other.isWriteIndex) && Objects.equals(this.mustExist, other.mustExist) && Objects.equals(this.routing, other.routing) && Objects.equals(this.searchRouting, other.searchRouting);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, AddAction> {
        @Nullable
        private String alias;
        @Nullable
        private List<String> aliases;
        @Nullable
        private Query filter;
        @Nullable
        private String index;
        @Nullable
        private String indexRouting;
        @Nullable
        private List<String> indices;
        @Nullable
        private Boolean isHidden;
        @Nullable
        private Boolean isWriteIndex;
        @Nullable
        private Boolean mustExist;
        @Nullable
        private String routing;
        @Nullable
        private String searchRouting;

        public Builder() {
        }

        private Builder(AddAction o) {
            this.alias = o.alias;
            this.aliases = Builder._listCopy(o.aliases);
            this.filter = o.filter;
            this.index = o.index;
            this.indexRouting = o.indexRouting;
            this.indices = Builder._listCopy(o.indices);
            this.isHidden = o.isHidden;
            this.isWriteIndex = o.isWriteIndex;
            this.mustExist = o.mustExist;
            this.routing = o.routing;
            this.searchRouting = o.searchRouting;
        }

        private Builder(Builder o) {
            this.alias = o.alias;
            this.aliases = Builder._listCopy(o.aliases);
            this.filter = o.filter;
            this.index = o.index;
            this.indexRouting = o.indexRouting;
            this.indices = Builder._listCopy(o.indices);
            this.isHidden = o.isHidden;
            this.isWriteIndex = o.isWriteIndex;
            this.mustExist = o.mustExist;
            this.routing = o.routing;
            this.searchRouting = o.searchRouting;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder alias(@Nullable String value) {
            this.alias = value;
            return this;
        }

        @Nonnull
        public final Builder aliases(List<String> list) {
            this.aliases = Builder._listAddAll(this.aliases, list);
            return this;
        }

        @Nonnull
        public final Builder aliases(String value, String ... values) {
            this.aliases = Builder._listAdd(this.aliases, value, values);
            return this;
        }

        @Nonnull
        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        @Nonnull
        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder indexRouting(@Nullable String value) {
            this.indexRouting = value;
            return this;
        }

        @Nonnull
        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Nonnull
        public final Builder isHidden(@Nullable Boolean value) {
            this.isHidden = value;
            return this;
        }

        @Nonnull
        public final Builder isWriteIndex(@Nullable Boolean value) {
            this.isWriteIndex = value;
            return this;
        }

        @Nonnull
        public final Builder mustExist(@Nullable Boolean value) {
            this.mustExist = value;
            return this;
        }

        @Nonnull
        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder searchRouting(@Nullable String value) {
            this.searchRouting = value;
            return this;
        }

        @Override
        @Nonnull
        public AddAction build() {
            this._checkSingleUse();
            return new AddAction(this);
        }
    }
}

