/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.reload_secure_settings;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NodeReloadResult
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, NodeReloadResult> {
    @Nonnull
    private final String name;
    @Nullable
    private final ErrorCause reloadException;
    public static final JsonpDeserializer<NodeReloadResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeReloadResult::setupNodeReloadResultDeserializer);

    private NodeReloadResult(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.reloadException = builder.reloadException;
    }

    public static NodeReloadResult of(Function<Builder, ObjectBuilder<NodeReloadResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nullable
    public final ErrorCause reloadException() {
        return this.reloadException;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.reloadException != null) {
            generator.writeKey("reload_exception");
            this.reloadException.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNodeReloadResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::reloadException, ErrorCause._DESERIALIZER, "reload_exception");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.reloadException);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeReloadResult other = (NodeReloadResult)o;
        return this.name.equals(other.name) && Objects.equals(this.reloadException, other.reloadException);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NodeReloadResult> {
        private String name;
        @Nullable
        private ErrorCause reloadException;

        public Builder() {
        }

        private Builder(NodeReloadResult o) {
            this.name = o.name;
            this.reloadException = o.reloadException;
        }

        private Builder(Builder o) {
            this.name = o.name;
            this.reloadException = o.reloadException;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder reloadException(@Nullable ErrorCause value) {
            this.reloadException = value;
            return this;
        }

        @Nonnull
        public final Builder reloadException(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.reloadException(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        @Nonnull
        public NodeReloadResult build() {
            this._checkSingleUse();
            return new NodeReloadResult(this);
        }
    }
}

