/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

final class Ed25519PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    private final byte[] data = new byte[32];
    private final Ed25519 ed25519 = new Ed25519(){

        @Override
        protected Digest createDigest() {
            return FipsSHS.createDigest(FipsSHS.Algorithm.SHA512);
        }
    };

    public Ed25519PublicKeyParameters(byte[] byArray) {
        this(Ed25519PublicKeyParameters.validate(byArray), 0);
    }

    public Ed25519PublicKeyParameters(byte[] byArray, int n) {
        super(false);
        System.arraycopy(byArray, n, this.data, 0, 32);
    }

    public Ed25519PublicKeyParameters(InputStream inputStream) throws IOException {
        super(false);
        if (32 != Streams.readFully(inputStream, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed25519 public key");
        }
    }

    public void encode(byte[] byArray, int n) {
        System.arraycopy(this.data, 0, byArray, n, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public boolean verify(int n, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        switch (n) {
            case 0: {
                if (null != byArray) {
                    throw new IllegalArgumentException("ctx");
                }
                return this.ed25519.verify(byArray3, n4, this.data, 0, byArray2, n2, n3);
            }
            case 1: {
                return this.ed25519.verify(byArray3, n4, this.data, 0, byArray, byArray2, n2, n3);
            }
            case 2: {
                if (64 != n3) {
                    throw new IllegalArgumentException("msgLen");
                }
                return this.ed25519.verifyPrehash(byArray3, n4, this.data, 0, byArray, byArray2, n2);
            }
        }
        throw new IllegalArgumentException("algorithm");
    }

    private static byte[] validate(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("'buf' must have length 32");
        }
        return byArray;
    }
}

