/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.zjsonpatch.JsonDiff;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.configuration.ConfigurationMap;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.configuration.SecurityConfigVersionDocument;
import org.opensearch.security.configuration.SecurityConfigVersionsLoader;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class RollbackVersionApiAction
extends AbstractApiAction {
    private static final Logger log = LogManager.getLogger(RollbackVersionApiAction.class);
    private static final long CONFIG_WRITE_TIMEOUT_SECONDS = 20L;
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, "/version/rollback"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/version/rollback/{versionID}")));
    private final SecurityConfigVersionsLoader versionsLoader;
    private final ConfigurationRepository configRepository;
    private final Client client;

    public RollbackVersionApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies, SecurityConfigVersionsLoader versionsLoader, ConfigurationRepository configRepository, Client client) {
        super(Endpoint.ROLLBACK_VERSION, clusterService, threadPool, securityApiDependencies);
        this.versionsLoader = versionsLoader;
        this.configRepository = configRepository;
        this.client = client;
        this.requestHandlersBuilder.allMethodsNotImplemented().override(RestRequest.Method.POST, (channel, request, unusedclient) -> {
            ValidationResult<SecurityConfiguration> result = this.handlePostRequest(request);
            result.valid((CheckedConsumer<SecurityConfiguration, IOException>)((CheckedConsumer)securityConfiguration -> {
                try {
                    XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
                    builder.startObject();
                    builder.field("status", "OK");
                    builder.field("message", "config rolled back to version " + request.param("versionID", "previous"));
                    builder.endObject();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                }
                catch (IOException e) {
                    log.error("Failed to send rollback response", (Throwable)e);
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
                }
            })).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, content) -> {
                try {
                    XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
                    content.toXContent(builder, null);
                    channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
                }
                catch (IOException e) {
                    log.error("Failed to build error response", (Throwable)e);
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
                }
            }));
        });
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType<?> getConfigType() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ValidationResult<SecurityConfiguration> handlePostRequest(RestRequest request) throws IOException {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        String versionParam = request.param("versionID");
        try (ThreadContext.StoredContext ctx = threadContext.stashContext();){
            if (versionParam == null) {
                ValidationResult<SecurityConfiguration> validationResult2 = this.rollbackToPreviousVersion();
                return validationResult2;
            }
            ValidationResult<SecurityConfiguration> validationResult = this.rollbackToSpecificVersion(versionParam);
            return validationResult;
        }
        catch (Exception e) {
            log.error("Rollback request failed", (Throwable)e);
            return ValidationResult.error(RestStatus.INTERNAL_SERVER_ERROR, Responses.payload(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
        }
    }

    private ValidationResult<SecurityConfiguration> rollbackToPreviousVersion() throws IOException {
        SecurityConfigVersionDocument doc = this.versionsLoader.loadFullDocument();
        List<SecurityConfigVersionDocument.Version<?>> versions = doc.getVersions();
        if (versions.size() < 2) {
            return ValidationResult.error(RestStatus.NOT_FOUND, Responses.payload(RestStatus.NOT_FOUND, "No previous version available to rollback"));
        }
        SecurityConfigVersionsLoader.sortVersionsById(doc.getVersions());
        String previousVersionId = versions.get(versions.size() - 2).getVersion_id();
        return this.rollbackCommon(previousVersionId, doc);
    }

    private ValidationResult<SecurityConfiguration> rollbackToSpecificVersion(String versionId) throws IOException {
        SecurityConfigVersionDocument doc = this.versionsLoader.loadFullDocument();
        Optional<SecurityConfigVersionDocument.Version> versionSpecificDoc = doc.getVersions().stream().filter(v -> versionId.equals(v.getVersion_id())).findFirst();
        if (versionSpecificDoc.isEmpty()) {
            return ValidationResult.error(RestStatus.NOT_FOUND, Responses.payload(RestStatus.NOT_FOUND, "Version " + versionId + " not found"));
        }
        return this.rollbackCommon(versionId, doc);
    }

    private ValidationResult<SecurityConfiguration> rollbackCommon(String versionId, SecurityConfigVersionDocument doc) throws IOException {
        SecurityConfigVersionDocument.Version versionSpecificDoc = doc.getVersions().stream().filter(v -> versionId.equals(v.getVersion_id())).findFirst().orElse(null);
        try {
            this.rollbackConfigsToSecurityIndex(versionSpecificDoc);
            return ValidationResult.error(RestStatus.OK, (builder, params) -> {
                XContentBuilder inner = this.buildRollbackResponseJson(versionId);
                builder.copyCurrentStructure(JsonXContent.jsonXContent.createParser(null, null, (InputStream)BytesReference.bytes((XContentBuilder)inner).streamInput()));
                return builder;
            });
        }
        catch (Exception e) {
            log.error("Rollback to version {} failed", (Object)versionId, (Object)e);
            return ValidationResult.error(RestStatus.INTERNAL_SERVER_ERROR, Responses.payload(RestStatus.INTERNAL_SERVER_ERROR, "Rollback failed: " + e.getMessage()));
        }
    }

    private void rollbackConfigsToSecurityIndex(SecurityConfigVersionDocument.Version<?> versionData) throws IOException {
        Map<String, SecurityConfigVersionDocument.HistoricSecurityConfig<?>> securityConfigs = versionData.getSecurity_configs();
        if (securityConfigs == null || securityConfigs.isEmpty()) {
            throw new NullPointerException("No security configs to rollback in version " + versionData.getVersion_id());
        }
        HashMap configsToApply = new HashMap();
        HashMap backups = new HashMap();
        try {
            ConfigurationMap currentConfigs = this.configRepository.getConfigurationsFromIndex(CType.values(), false, true);
            for (Map.Entry<String, SecurityConfigVersionDocument.HistoricSecurityConfig<?>> entry : securityConfigs.entrySet()) {
                String cTypeName = entry.getKey();
                SecurityConfigVersionDocument.HistoricSecurityConfig<?> sc = entry.getValue();
                CType<?> cType = CType.fromString(cTypeName);
                if (cType == null) {
                    throw new NullPointerException("Rollback aborted: Unknown config type '" + cTypeName + "' found in version");
                }
                if (sc == null || sc.getConfigData() == null) {
                    log.warn("Skipping cType '{}' due to null configData", (Object)cTypeName);
                    continue;
                }
                SecurityDynamicConfiguration<?> currentConfig = currentConfigs.get(cType);
                if (currentConfig == null) {
                    throw new IllegalArgumentException("Rollback aborted: Could not fetch current config for cType '" + cTypeName + "'");
                }
                SecurityDynamicConfiguration<?> rollBackConfig = SecurityDynamicConfiguration.empty(cType);
                rollBackConfig.setSeqNo(currentConfig.getSeqNo());
                rollBackConfig.setPrimaryTerm(currentConfig.getPrimaryTerm());
                for (Map.Entry<String, SecurityDynamicConfiguration<?>> configEntry : sc.getConfigData().entrySet()) {
                    if ("_meta".equals(configEntry.getKey())) continue;
                    rollBackConfig.putCObject(configEntry.getKey(), configEntry.getValue());
                }
                if (this.isConfigEqual(currentConfig, rollBackConfig)) {
                    log.info("Skipping rollback for cType '{}' as there are no changes", (Object)cTypeName);
                    continue;
                }
                backups.put(cType, currentConfig);
                configsToApply.put(cType, rollBackConfig);
            }
            try {
                this.writeConfigsWithLatch(configsToApply);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException("Rollback was interrupted", ie);
            }
        }
        catch (Exception e) {
            log.error("Rollback to version {} failed", (Object)versionData.getVersion_id(), (Object)e);
            this.revertRollbackOnFailure(backups, e);
        }
    }

    private void writeConfigsWithLatch(Map<CType<?>, SecurityDynamicConfiguration<?>> configsToApply) throws IOException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(configsToApply.size());
        for (final Map.Entry<CType<?>, SecurityDynamicConfiguration<?>> entry : configsToApply.entrySet()) {
            AbstractApiAction.saveAndUpdateConfigsAsync(this.securityApiDependencies, this.client, entry.getKey(), entry.getValue(), new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse r) {
                    latch.countDown();
                }

                public void onFailure(Exception e) {
                    log.error("Rollback: failed to write config for cType={} : {}", (Object)((CType)entry.getKey()).toLCString(), (Object)e.getMessage(), (Object)e);
                    latch.countDown();
                }
            });
            log.info("Rollback: wrote config data for cType={}", (Object)entry.getKey().toLCString());
        }
        if (!latch.await(20L, TimeUnit.SECONDS)) {
            throw new IOException("Timeout while writing rolled-back configs");
        }
    }

    private void revertRollbackOnFailure(Map<CType<?>, SecurityDynamicConfiguration<?>> backups, Exception originalException) throws IOException {
        log.error("Rollback failed mid-way. Reverting previous updates...", (Throwable)originalException);
        final CountDownLatch latch = new CountDownLatch(backups.size());
        for (final Map.Entry<CType<?>, SecurityDynamicConfiguration<?>> entry : backups.entrySet()) {
            AbstractApiAction.saveAndUpdateConfigsAsync(this.securityApiDependencies, this.client, entry.getKey(), entry.getValue(), new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    log.info("Rollback revert: restored previous config for cType={}", (Object)((CType)entry.getKey()).toLCString());
                    latch.countDown();
                }

                public void onFailure(Exception e) {
                    log.error("Failed to revert config for cType={}", (Object)((CType)entry.getKey()).toLCString(), (Object)e);
                    latch.countDown();
                }
            });
        }
        try {
            if (!latch.await(20L, TimeUnit.SECONDS)) {
                throw new IOException("Timeout while reverting rollback configs");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Rollback revert was interrupted", ie);
        }
        throw new IOException("Rollback aborted and reverted due to failure in writing config: " + originalException.getMessage(), originalException);
    }

    private XContentBuilder buildRollbackResponseJson(String versionId) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
        builder.startObject();
        builder.field("status", "OK");
        builder.field("message", "config rolled back to version " + versionId);
        builder.endObject();
        return builder;
    }

    public boolean isConfigEqual(SecurityDynamicConfiguration<?> currentConfig, SecurityDynamicConfiguration<?> targetConfig) {
        if (currentConfig.getCEntries().equals(targetConfig.getCEntries())) {
            return true;
        }
        try {
            JsonNode currentJson = DefaultObjectMapper.objectMapper.valueToTree(currentConfig.getCEntries());
            JsonNode targetJson = DefaultObjectMapper.objectMapper.valueToTree(targetConfig.getCEntries());
            JsonNode diff = JsonDiff.asJson((JsonNode)currentJson, (JsonNode)targetJson);
            if (!diff.isEmpty()) {
                log.debug("Config difference detected: {}", (Object)diff.toString());
            }
            return diff.isEmpty();
        }
        catch (Exception e) {
            log.error("Failed to compare configs for equality using JsonDiff", (Throwable)e);
            return false;
        }
    }

    @Override
    protected void consumeParameters(RestRequest request) {
        request.param("versionID");
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return RollbackVersionApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return RollbackVersionApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigLoad(SecurityConfiguration securityConfiguration) {
                return ValidationResult.success(securityConfiguration);
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigDelete(SecurityConfiguration securityConfiguration) {
                return ValidationResult.error(RestStatus.FORBIDDEN, Responses.forbiddenMessage("Delete not supported for rollback"));
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigChange(SecurityConfiguration securityConfiguration) {
                return ValidationResult.success(securityConfiguration);
            }

            @Override
            public RequestContentValidator createRequestContentValidator(Object ... params) {
                return RequestContentValidator.NOOP_VALIDATOR;
            }
        };
    }
}

