/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf;

import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auth.AuthDomain;
import org.opensearch.security.auth.AuthFailureListener;
import org.opensearch.security.auth.AuthorizationBackend;
import org.opensearch.security.auth.blocking.ClientBlockRegistry;
import org.opensearch.security.auth.http.jwt.keybyjwks.HTTPJwtKeyByJWKSAuthenticator;
import org.opensearch.security.auth.http.jwt.keybyoidc.HTTPJwtKeyByOpenIdConnectAuthenticator;
import org.opensearch.security.auth.http.kerberos.HTTPSpnegoAuthenticator;
import org.opensearch.security.auth.http.saml.HTTPSamlAuthenticator;
import org.opensearch.security.auth.internal.InternalAuthenticationBackend;
import org.opensearch.security.auth.internal.NoOpAuthenticationBackend;
import org.opensearch.security.auth.internal.NoOpAuthorizationBackend;
import org.opensearch.security.auth.ldap.backend.LDAPAuthenticationBackend;
import org.opensearch.security.auth.ldap.backend.LDAPAuthorizationBackend;
import org.opensearch.security.auth.ldap2.LDAPAuthenticationBackend2;
import org.opensearch.security.auth.ldap2.LDAPAuthorizationBackend2;
import org.opensearch.security.auth.limiting.AddressBasedRateLimiter;
import org.opensearch.security.auth.limiting.UserNameBasedRateLimiter;
import org.opensearch.security.http.HTTPBasicAuthenticator;
import org.opensearch.security.http.HTTPClientCertAuthenticator;
import org.opensearch.security.http.HTTPProxyAuthenticator;
import org.opensearch.security.http.proxy.HTTPExtendedProxyAuthenticator;
import org.opensearch.security.securityconf.impl.DashboardSignInOption;

public abstract class DynamicConfigModel {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final Map<String, String> authImplMap = new HashMap<String, String>();

    public abstract SortedSet<AuthDomain> getRestAuthDomains();

    public abstract Set<AuthorizationBackend> getRestAuthorizers();

    public abstract boolean isAnonymousAuthenticationEnabled();

    public abstract boolean isXffEnabled();

    public abstract String getInternalProxies();

    public abstract String getRemoteIpHeader();

    public abstract boolean isRestAuthDisabled();

    public abstract boolean isInterTransportAuthDisabled();

    public abstract boolean isRespectRequestIndicesEnabled();

    public abstract String getDashboardsServerUsername();

    public abstract String getDashboardsOpenSearchRole();

    public abstract String getDashboardsIndexname();

    public abstract boolean isDashboardsMultitenancyEnabled();

    public abstract boolean isDashboardsPrivateTenantEnabled();

    public abstract String getDashboardsDefaultTenant();

    public abstract boolean isDnfofEnabled();

    public abstract boolean isMultiRolespanEnabled();

    public abstract String getFilteredAliasMode();

    public abstract String getHostsResolverMode();

    public abstract boolean isDnfofForEmptyResultsEnabled();

    public abstract List<AuthFailureListener> getIpAuthFailureListeners();

    public abstract Multimap<String, AuthFailureListener> getAuthBackendFailureListeners();

    public abstract List<ClientBlockRegistry<InetAddress>> getIpClientBlockRegistries();

    public abstract Multimap<String, ClientBlockRegistry<String>> getAuthBackendClientBlockRegistries();

    public abstract List<DashboardSignInOption> getSignInOptions();

    public abstract Settings getDynamicOnBehalfOfSettings();

    public DynamicConfigModel() {
        this.authImplMap.put("intern_c", InternalAuthenticationBackend.class.getName());
        this.authImplMap.put("intern_z", NoOpAuthorizationBackend.class.getName());
        this.authImplMap.put("internal_c", InternalAuthenticationBackend.class.getName());
        this.authImplMap.put("internal_z", NoOpAuthorizationBackend.class.getName());
        this.authImplMap.put("noop_c", NoOpAuthenticationBackend.class.getName());
        this.authImplMap.put("noop_z", NoOpAuthorizationBackend.class.getName());
        this.authImplMap.put("ldap_c", LDAPAuthenticationBackend.class.getName());
        this.authImplMap.put("ldap_z", LDAPAuthorizationBackend.class.getName());
        this.authImplMap.put("ldap2_c", LDAPAuthenticationBackend2.class.getName());
        this.authImplMap.put("ldap2_z", LDAPAuthorizationBackend2.class.getName());
        this.authImplMap.put("basic_h", HTTPBasicAuthenticator.class.getName());
        this.authImplMap.put("proxy_h", HTTPProxyAuthenticator.class.getName());
        this.authImplMap.put("extended-proxy_h", HTTPExtendedProxyAuthenticator.class.getName());
        this.authImplMap.put("clientcert_h", HTTPClientCertAuthenticator.class.getName());
        this.authImplMap.put("kerberos_h", HTTPSpnegoAuthenticator.class.getName());
        this.authImplMap.put("jwt_h", HTTPJwtKeyByJWKSAuthenticator.class.getName());
        this.authImplMap.put("openid_h", HTTPJwtKeyByOpenIdConnectAuthenticator.class.getName());
        this.authImplMap.put("saml_h", HTTPSamlAuthenticator.class.getName());
        this.authImplMap.put("ip_authFailureListener", AddressBasedRateLimiter.class.getName());
        this.authImplMap.put("username_authFailureListener", UserNameBasedRateLimiter.class.getName());
    }
}

