/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.ResponseAbstractType;
import org.opensaml.xmlsec.signature.Signature;

public abstract class ResponseAbstractTypeImpl
extends AbstractSignableSAMLObject
implements ResponseAbstractType {
    @Nullable
    private String id;
    @Nullable
    private SAMLVersion version = SAMLVersion.VERSION_11;
    @Nullable
    private String inResponseTo;
    @Nullable
    private Instant issueInstant;
    @Nullable
    private String recipient;

    protected ResponseAbstractTypeImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nullable
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(@Nullable String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    @Override
    @Nullable
    public String getInResponseTo() {
        return this.inResponseTo;
    }

    @Override
    public void setInResponseTo(@Nullable String to) {
        this.inResponseTo = this.prepareForAssignment(this.inResponseTo, to);
    }

    @Override
    @Nullable
    public SAMLVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(@Nullable SAMLVersion newVersion) {
        this.version = this.prepareForAssignment(this.version, newVersion);
    }

    @Override
    @Nullable
    public Instant getIssueInstant() {
        return this.issueInstant;
    }

    @Override
    public void setIssueInstant(@Nullable Instant date) {
        this.issueInstant = this.prepareForAssignment(this.issueInstant, date);
    }

    @Override
    @Nullable
    public String getRecipient() {
        return this.recipient;
    }

    @Override
    public void setRecipient(@Nullable String recip) {
        this.recipient = this.prepareForAssignment(this.recipient, recip);
    }

    @Override
    @Nullable
    public String getSignatureReferenceID() {
        return this.id;
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        Signature sig = this.getSignature();
        if (sig != null) {
            return CollectionSupport.singletonList(sig);
        }
        return null;
    }
}

