/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.xmlsec.encryption.CarriedKeyName;
import org.opensaml.xmlsec.encryption.DataReference;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.ReferenceList;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;

public abstract class AbstractEncryptedKeyResolver
implements EncryptedKeyResolver {
    @Nonnull
    private final Set<String> recipients;

    public AbstractEncryptedKeyResolver() {
        this.recipients = CollectionSupport.emptySet();
    }

    @Deprecated
    public AbstractEncryptedKeyResolver(@Nullable Set<String> newRecipents) {
        this.recipients = CollectionSupport.copyToSet(StringSupport.normalizeStringCollection(newRecipents));
    }

    public AbstractEncryptedKeyResolver(@Nullable String recipient) {
        String trimmed = StringSupport.trimOrNull(recipient);
        this.recipients = trimmed != null ? CollectionSupport.singleton(trimmed) : CollectionSupport.emptySet();
    }

    @Override
    @Deprecated
    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getRecipients() {
        return this.recipients;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Set<String> getEffectiveRecipients(@Nullable Set<String> values) {
        HashSet<String> temp = new HashSet<String>();
        temp.addAll(this.getRecipients());
        if (values != null) {
            temp.addAll(values);
        }
        return CollectionSupport.copyToSet(temp);
    }

    protected boolean matchRecipient(@Nullable String recipient, @Nonnull Set<String> validRecipients) {
        if (validRecipients.isEmpty()) {
            return true;
        }
        String trimmedRecipient = StringSupport.trimOrNull(recipient);
        if (trimmedRecipient == null) {
            return true;
        }
        return validRecipients.contains(trimmedRecipient);
    }

    protected boolean matchCarriedKeyName(@Nonnull EncryptedData encryptedData, @Nonnull EncryptedKey encryptedKey) {
        Constraint.isNotNull(encryptedData, "EncryptedData cannot be null");
        Constraint.isNotNull(encryptedKey, "EncryptedKey cannot be null");
        CarriedKeyName carried = encryptedKey.getCarriedKeyName();
        if (carried == null || Strings.isNullOrEmpty((String)carried.getValue())) {
            return true;
        }
        KeyInfo keyInfo = encryptedData.getKeyInfo();
        if (keyInfo == null || keyInfo.getKeyNames().isEmpty()) {
            return false;
        }
        return KeyInfoSupport.getKeyNames(keyInfo).contains(carried.getValue());
    }

    protected boolean matchDataReference(@Nonnull EncryptedData encryptedData, @Nonnull EncryptedKey encryptedKey) {
        Constraint.isNotNull(encryptedData, "EncryptedData cannot be null");
        Constraint.isNotNull(encryptedKey, "EncryptedKey cannot be null");
        ReferenceList reflist = encryptedKey.getReferenceList();
        if (reflist == null || reflist.getDataReferences().isEmpty()) {
            return true;
        }
        if (Strings.isNullOrEmpty((String)encryptedData.getID())) {
            return false;
        }
        List<DataReference> drlist = reflist.getDataReferences();
        for (DataReference dr : drlist) {
            String druri = dr.getURI();
            if (druri == null || !druri.startsWith("#") || dr.resolveIDFromRoot(druri.substring(1)) != encryptedData) continue;
            return true;
        }
        return false;
    }
}

