/**
 * ./src/lib/utils.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { spawn } from 'child_process';
/**
 *
 * @param command
 * @param param1
 * @returns
 */
export async function exec(command, { echo = false, ignore = false, capture = false } = {}) {
    return new Promise((resolve, reject) => {
        if (echo) {
            console.log(command);
        }
        // Opzioni di base per spawn
        const spawnOptions = {
            stdio: ignore ? 'ignore' : capture ? 'pipe' : 'inherit'
        };
        const child = spawn('bash', ['-c', command], spawnOptions);
        let stdout = '';
        if (capture) {
            child.stdout?.on('data', (data) => {
                stdout += data;
            });
        }
        child.on('error', (error) => {
            reject({ code: 1, error });
        });
        child.on('exit', (code) => {
            resolve({ code, data: stdout });
        });
    });
}
