/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.util.Comparator;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.control.ZapRelease;

public class ZapReleaseComparitor
implements Comparator<ZapRelease> {
    @Override
    public int compare(ZapRelease zr1, ZapRelease zr2) {
        if (zr1 == null) {
            if (zr2 == null) {
                return 0;
            }
            return 1;
        }
        if (zr2 == null) {
            return -1;
        }
        if (zr1.getVersion().equals(zr2.getVersion())) {
            return 0;
        }
        if (Constant.isDevBuild(zr1.getVersion())) {
            return 1;
        }
        if (Constant.isDevBuild(zr2.getVersion())) {
            return -1;
        }
        if (Constant.isDailyBuild(zr1.getVersion())) {
            if (Constant.isDailyBuild(zr2.getVersion())) {
                return zr1.getVersion().compareTo(zr2.getVersion());
            }
            return 1;
        }
        if (Constant.isDailyBuild(zr2.getVersion())) {
            return -1;
        }
        String[] zr1Array = zr1.getVersion().split("\\.");
        String[] zr2Array = zr2.getVersion().split("\\.");
        for (int i = 0; i < zr1Array.length; ++i) {
            if (i >= zr2Array.length) {
                return 1;
            }
            if (zr1Array[i].equals(zr2Array[i])) continue;
            Integer zr1Int = null;
            Integer zr2Int = null;
            try {
                zr1Int = Integer.parseInt(zr1Array[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                zr2Int = Integer.parseInt(zr2Array[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (zr1Int != null) {
                if (zr2Int != null) {
                    return zr1Int - zr2Int;
                }
                if (zr2Array[i].equals("alpha") || zr2Array[i].equals("beta")) {
                    return 1;
                }
                throw new IllegalArgumentException("Invalid release number: " + String.valueOf(zr2));
            }
            if (zr2Int != null) {
                if (zr1Array[i].equals("alpha") || zr1Array[i].equals("beta")) {
                    return -1;
                }
                throw new IllegalArgumentException("Invalid release number: " + zr1.getVersion());
            }
            if (zr1Array[i].equals("alpha")) {
                return -1;
            }
            if (zr1Array[i].equals("beta")) {
                return 1;
            }
            throw new IllegalArgumentException("Invalid release number: " + zr1.getVersion());
        }
        return -1;
    }
}

