﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {
class UpdateEmailAddressMetadataResult {
 public:
  AWS_CONNECT_API UpdateEmailAddressMetadataResult() = default;
  AWS_CONNECT_API UpdateEmailAddressMetadataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONNECT_API UpdateEmailAddressMetadataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The identifier of the email address.</p>
   */
  inline const Aws::String& GetEmailAddressId() const { return m_emailAddressId; }
  template <typename EmailAddressIdT = Aws::String>
  void SetEmailAddressId(EmailAddressIdT&& value) {
    m_emailAddressIdHasBeenSet = true;
    m_emailAddressId = std::forward<EmailAddressIdT>(value);
  }
  template <typename EmailAddressIdT = Aws::String>
  UpdateEmailAddressMetadataResult& WithEmailAddressId(EmailAddressIdT&& value) {
    SetEmailAddressId(std::forward<EmailAddressIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the email address.</p>
   */
  inline const Aws::String& GetEmailAddressArn() const { return m_emailAddressArn; }
  template <typename EmailAddressArnT = Aws::String>
  void SetEmailAddressArn(EmailAddressArnT&& value) {
    m_emailAddressArnHasBeenSet = true;
    m_emailAddressArn = std::forward<EmailAddressArnT>(value);
  }
  template <typename EmailAddressArnT = Aws::String>
  UpdateEmailAddressMetadataResult& WithEmailAddressArn(EmailAddressArnT&& value) {
    SetEmailAddressArn(std::forward<EmailAddressArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateEmailAddressMetadataResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_emailAddressId;
  bool m_emailAddressIdHasBeenSet = false;

  Aws::String m_emailAddressArn;
  bool m_emailAddressArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
