﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigateway/APIGateway_EXPORTS.h>
#include <aws/apigateway/model/ApiKeySourceType.h>
#include <aws/apigateway/model/ApiStatus.h>
#include <aws/apigateway/model/EndpointAccessMode.h>
#include <aws/apigateway/model/EndpointConfiguration.h>
#include <aws/apigateway/model/SecurityPolicy.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace APIGateway {
namespace Model {
/**
 * <p>Represents a REST API.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/apigateway-2015-07-09/RestApi">AWS
 * API Reference</a></p>
 */
class CreateRestApiResult {
 public:
  AWS_APIGATEWAY_API CreateRestApiResult() = default;
  AWS_APIGATEWAY_API CreateRestApiResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APIGATEWAY_API CreateRestApiResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The API's identifier. This identifier is unique across all of your APIs in
   * API Gateway.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  CreateRestApiResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The API's name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateRestApiResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The API's description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreateRestApiResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timestamp when the API was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedDate() const { return m_createdDate; }
  template <typename CreatedDateT = Aws::Utils::DateTime>
  void SetCreatedDate(CreatedDateT&& value) {
    m_createdDateHasBeenSet = true;
    m_createdDate = std::forward<CreatedDateT>(value);
  }
  template <typename CreatedDateT = Aws::Utils::DateTime>
  CreateRestApiResult& WithCreatedDate(CreatedDateT&& value) {
    SetCreatedDate(std::forward<CreatedDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A version identifier for the API.</p>
   */
  inline const Aws::String& GetVersion() const { return m_version; }
  template <typename VersionT = Aws::String>
  void SetVersion(VersionT&& value) {
    m_versionHasBeenSet = true;
    m_version = std::forward<VersionT>(value);
  }
  template <typename VersionT = Aws::String>
  CreateRestApiResult& WithVersion(VersionT&& value) {
    SetVersion(std::forward<VersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The warning messages reported when <code>failonwarnings</code> is turned on
   * during API import.</p>
   */
  inline const Aws::Vector<Aws::String>& GetWarnings() const { return m_warnings; }
  template <typename WarningsT = Aws::Vector<Aws::String>>
  void SetWarnings(WarningsT&& value) {
    m_warningsHasBeenSet = true;
    m_warnings = std::forward<WarningsT>(value);
  }
  template <typename WarningsT = Aws::Vector<Aws::String>>
  CreateRestApiResult& WithWarnings(WarningsT&& value) {
    SetWarnings(std::forward<WarningsT>(value));
    return *this;
  }
  template <typename WarningsT = Aws::String>
  CreateRestApiResult& AddWarnings(WarningsT&& value) {
    m_warningsHasBeenSet = true;
    m_warnings.emplace_back(std::forward<WarningsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of binary media types supported by the RestApi. By default, the
   * RestApi supports only UTF-8-encoded text payloads.</p>
   */
  inline const Aws::Vector<Aws::String>& GetBinaryMediaTypes() const { return m_binaryMediaTypes; }
  template <typename BinaryMediaTypesT = Aws::Vector<Aws::String>>
  void SetBinaryMediaTypes(BinaryMediaTypesT&& value) {
    m_binaryMediaTypesHasBeenSet = true;
    m_binaryMediaTypes = std::forward<BinaryMediaTypesT>(value);
  }
  template <typename BinaryMediaTypesT = Aws::Vector<Aws::String>>
  CreateRestApiResult& WithBinaryMediaTypes(BinaryMediaTypesT&& value) {
    SetBinaryMediaTypes(std::forward<BinaryMediaTypesT>(value));
    return *this;
  }
  template <typename BinaryMediaTypesT = Aws::String>
  CreateRestApiResult& AddBinaryMediaTypes(BinaryMediaTypesT&& value) {
    m_binaryMediaTypesHasBeenSet = true;
    m_binaryMediaTypes.emplace_back(std::forward<BinaryMediaTypesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A nullable integer that is used to enable compression (with non-negative
   * between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a
   * null value) on an API. When compression is enabled, compression or decompression
   * is not applied on the payload if the payload size is smaller than this value.
   * Setting it to zero allows compression for any payload size.</p>
   */
  inline int GetMinimumCompressionSize() const { return m_minimumCompressionSize; }
  inline void SetMinimumCompressionSize(int value) {
    m_minimumCompressionSizeHasBeenSet = true;
    m_minimumCompressionSize = value;
  }
  inline CreateRestApiResult& WithMinimumCompressionSize(int value) {
    SetMinimumCompressionSize(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The source of the API key for metering requests according to a usage plan.
   * Valid values are: &gt;<code>HEADER</code> to read the API key from the
   * <code>X-API-Key</code> header of a request. <code>AUTHORIZER</code> to read the
   * API key from the <code>UsageIdentifierKey</code> from a custom authorizer.</p>
   */
  inline ApiKeySourceType GetApiKeySource() const { return m_apiKeySource; }
  inline void SetApiKeySource(ApiKeySourceType value) {
    m_apiKeySourceHasBeenSet = true;
    m_apiKeySource = value;
  }
  inline CreateRestApiResult& WithApiKeySource(ApiKeySourceType value) {
    SetApiKeySource(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The endpoint configuration of this RestApi showing the endpoint types and IP
   * address types of the API. </p>
   */
  inline const EndpointConfiguration& GetEndpointConfiguration() const { return m_endpointConfiguration; }
  template <typename EndpointConfigurationT = EndpointConfiguration>
  void SetEndpointConfiguration(EndpointConfigurationT&& value) {
    m_endpointConfigurationHasBeenSet = true;
    m_endpointConfiguration = std::forward<EndpointConfigurationT>(value);
  }
  template <typename EndpointConfigurationT = EndpointConfiguration>
  CreateRestApiResult& WithEndpointConfiguration(EndpointConfigurationT&& value) {
    SetEndpointConfiguration(std::forward<EndpointConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A stringified JSON policy document that applies to this RestApi regardless of
   * the caller and Method configuration.</p>
   */
  inline const Aws::String& GetPolicy() const { return m_policy; }
  template <typename PolicyT = Aws::String>
  void SetPolicy(PolicyT&& value) {
    m_policyHasBeenSet = true;
    m_policy = std::forward<PolicyT>(value);
  }
  template <typename PolicyT = Aws::String>
  CreateRestApiResult& WithPolicy(PolicyT&& value) {
    SetPolicy(std::forward<PolicyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The collection of tags. Each tag element is associated with a given
   * resource.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  CreateRestApiResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  CreateRestApiResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether clients can invoke your API by using the default
   * <code>execute-api</code> endpoint. By default, clients can invoke your API with
   * the default <code>https://{api_id}.execute-api.{region}.amazonaws.com</code>
   * endpoint. To require that clients use a custom domain name to invoke your API,
   * disable the default endpoint.</p>
   */
  inline bool GetDisableExecuteApiEndpoint() const { return m_disableExecuteApiEndpoint; }
  inline void SetDisableExecuteApiEndpoint(bool value) {
    m_disableExecuteApiEndpointHasBeenSet = true;
    m_disableExecuteApiEndpoint = value;
  }
  inline CreateRestApiResult& WithDisableExecuteApiEndpoint(bool value) {
    SetDisableExecuteApiEndpoint(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The API's root resource ID.</p>
   */
  inline const Aws::String& GetRootResourceId() const { return m_rootResourceId; }
  template <typename RootResourceIdT = Aws::String>
  void SetRootResourceId(RootResourceIdT&& value) {
    m_rootResourceIdHasBeenSet = true;
    m_rootResourceId = std::forward<RootResourceIdT>(value);
  }
  template <typename RootResourceIdT = Aws::String>
  CreateRestApiResult& WithRootResourceId(RootResourceIdT&& value) {
    SetRootResourceId(std::forward<RootResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Transport Layer Security (TLS) version + cipher suite for this RestApi.
   * </p>
   */
  inline SecurityPolicy GetSecurityPolicy() const { return m_securityPolicy; }
  inline void SetSecurityPolicy(SecurityPolicy value) {
    m_securityPolicyHasBeenSet = true;
    m_securityPolicy = value;
  }
  inline CreateRestApiResult& WithSecurityPolicy(SecurityPolicy value) {
    SetSecurityPolicy(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The endpoint access mode of the RestApi. </p>
   */
  inline EndpointAccessMode GetEndpointAccessMode() const { return m_endpointAccessMode; }
  inline void SetEndpointAccessMode(EndpointAccessMode value) {
    m_endpointAccessModeHasBeenSet = true;
    m_endpointAccessMode = value;
  }
  inline CreateRestApiResult& WithEndpointAccessMode(EndpointAccessMode value) {
    SetEndpointAccessMode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ApiStatus of the RestApi. </p>
   */
  inline ApiStatus GetApiStatus() const { return m_apiStatus; }
  inline void SetApiStatus(ApiStatus value) {
    m_apiStatusHasBeenSet = true;
    m_apiStatus = value;
  }
  inline CreateRestApiResult& WithApiStatus(ApiStatus value) {
    SetApiStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The status message of the RestApi. When the status message is
   * <code>UPDATING</code> you can still invoke it. </p>
   */
  inline const Aws::String& GetApiStatusMessage() const { return m_apiStatusMessage; }
  template <typename ApiStatusMessageT = Aws::String>
  void SetApiStatusMessage(ApiStatusMessageT&& value) {
    m_apiStatusMessageHasBeenSet = true;
    m_apiStatusMessage = std::forward<ApiStatusMessageT>(value);
  }
  template <typename ApiStatusMessageT = Aws::String>
  CreateRestApiResult& WithApiStatusMessage(ApiStatusMessageT&& value) {
    SetApiStatusMessage(std::forward<ApiStatusMessageT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateRestApiResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_name;

  Aws::String m_description;

  Aws::Utils::DateTime m_createdDate{};

  Aws::String m_version;

  Aws::Vector<Aws::String> m_warnings;

  Aws::Vector<Aws::String> m_binaryMediaTypes;

  int m_minimumCompressionSize{0};

  ApiKeySourceType m_apiKeySource{ApiKeySourceType::NOT_SET};

  EndpointConfiguration m_endpointConfiguration;

  Aws::String m_policy;

  Aws::Map<Aws::String, Aws::String> m_tags;

  bool m_disableExecuteApiEndpoint{false};

  Aws::String m_rootResourceId;

  SecurityPolicy m_securityPolicy{SecurityPolicy::NOT_SET};

  EndpointAccessMode m_endpointAccessMode{EndpointAccessMode::NOT_SET};

  ApiStatus m_apiStatus{ApiStatus::NOT_SET};

  Aws::String m_apiStatusMessage;

  Aws::String m_requestId;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_createdDateHasBeenSet = false;
  bool m_versionHasBeenSet = false;
  bool m_warningsHasBeenSet = false;
  bool m_binaryMediaTypesHasBeenSet = false;
  bool m_minimumCompressionSizeHasBeenSet = false;
  bool m_apiKeySourceHasBeenSet = false;
  bool m_endpointConfigurationHasBeenSet = false;
  bool m_policyHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_disableExecuteApiEndpointHasBeenSet = false;
  bool m_rootResourceIdHasBeenSet = false;
  bool m_securityPolicyHasBeenSet = false;
  bool m_endpointAccessModeHasBeenSet = false;
  bool m_apiStatusHasBeenSet = false;
  bool m_apiStatusMessageHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace APIGateway
}  // namespace Aws
