﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codebuild/CodeBuild_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeBuild {
namespace Model {
class ListSharedReportGroupsResult {
 public:
  AWS_CODEBUILD_API ListSharedReportGroupsResult() = default;
  AWS_CODEBUILD_API ListSharedReportGroupsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEBUILD_API ListSharedReportGroupsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> During a previous call, the maximum number of items that can be returned is
   * the value specified in <code>maxResults</code>. If there more items in the list,
   * then a unique string called a <i>nextToken</i> is returned. To get the next
   * batch of items in the list, call this operation again, adding the next token to
   * the call. To get all of the items in the list, keep calling this operation with
   * each subsequent next token that is returned, until no more next tokens are
   * returned. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListSharedReportGroupsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The list of ARNs for the report groups shared with the current Amazon Web
   * Services account or user. </p>
   */
  inline const Aws::Vector<Aws::String>& GetReportGroups() const { return m_reportGroups; }
  template <typename ReportGroupsT = Aws::Vector<Aws::String>>
  void SetReportGroups(ReportGroupsT&& value) {
    m_reportGroupsHasBeenSet = true;
    m_reportGroups = std::forward<ReportGroupsT>(value);
  }
  template <typename ReportGroupsT = Aws::Vector<Aws::String>>
  ListSharedReportGroupsResult& WithReportGroups(ReportGroupsT&& value) {
    SetReportGroups(std::forward<ReportGroupsT>(value));
    return *this;
  }
  template <typename ReportGroupsT = Aws::String>
  ListSharedReportGroupsResult& AddReportGroups(ReportGroupsT&& value) {
    m_reportGroupsHasBeenSet = true;
    m_reportGroups.emplace_back(std::forward<ReportGroupsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListSharedReportGroupsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<Aws::String> m_reportGroups;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_reportGroupsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeBuild
}  // namespace Aws
