/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;

public class FilterDialogSelectionListener
implements ISelectionChangedListener {
    private Label descriptionText;

    protected FilterDialogSelectionListener(Label aDescriptionText) {
        this.descriptionText = aDescriptionText;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection structuredSelection = event.getStructuredSelection();
        Object element = structuredSelection.getFirstElement();
        if (element instanceof INavigatorContentDescriptor) {
            INavigatorContentDescriptor ncd = (INavigatorContentDescriptor)element;
            String desc = NLS.bind((String)CommonNavigatorMessages.CommonFilterSelectionDialog_Hides_all_content_associated, (Object[])new Object[]{ncd.getName()});
            this.descriptionText.setText(desc);
        } else if (element instanceof ICommonFilterDescriptor) {
            ICommonFilterDescriptor cfd = (ICommonFilterDescriptor)element;
            String description = cfd.getDescription();
            if (description != null) {
                this.descriptionText.setText(description);
            } else {
                this.descriptionText.setText(NLS.bind((String)CommonNavigatorMessages.FilterDialogSelectionListener_Enable_the_0_filter_, (Object)cfd.getName()));
            }
        }
    }
}

