
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was AuthConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/DDM" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# 导入 AuthTargets 文件
include("${CMAKE_CURRENT_LIST_DIR}/AuthTargets.cmake")

# 如果定义了 COMPONENTS 选项，则导出相应的信息
if(DEFINED COMPONENTS)
    foreach(comp ${COMPONENTS})
        if(comp STREQUAL "Auth")
            set(Auth_FOUND TRUE)
            set(Auth_INCLUDE_DIRS "${CMAKE_INSTALL_PREFIX}/include/ddm")
            set(Auth_LIBRARIES Auth)
        else()
            message(FATAL_ERROR "Unknown component: ${comp}")
        endif()
    endforeach()
endif()

# 如果没有定义 COMPONENTS 选项，则默认导出所有信息
if(NOT DEFINED COMPONENTS OR "${COMPONENTS}" STREQUAL "Auth")
    set(Auth_FOUND TRUE)
    set(Auth_INCLUDE_DIRS "${CMAKE_INSTALL_PREFIX}/include/ddm")
    set(Auth_LIBRARIES Auth)
endif()

# 检查是否找到了相应的组件
if(NOT Auth_FOUND)
    message(FATAL_ERROR "Auth component not found.")
endif()

# 导出 Auth 的头文件路径和库文件
set(Auth_INCLUDE_DIRS ${Auth_INCLUDE_DIRS} ${Auth_INCLUDE_DIRS} PARENT_SCOPE)
set(Auth_LIBRARIES ${Auth_LIBRARIES} ${Auth_LIBRARIES} PARENT_SCOPE)

