/*
 * This file is part of Freecell Solver. It is subject to the license terms in
 * the COPYING.txt file found in the top-level directory of this distribution
 * and at http://fc-solve.shlomifish.org/docs/distro/COPYING.html . No part of
 * Freecell Solver, including this file, may be copied, modified, propagated,
 * or distributed except according to the terms contained in the COPYING file.
 *
 * Copyright (c) 2000 Shlomi Fish
 */
/*
 * config.h - Configuration file for Freecell Solver
 *
 * config.h was auto-generated from config.h.in . Do not modify directly
*/
#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#include "freecell-solver/fcs_back_compat.h"

/* #undef COMPACT_STATES */
#define INDIRECT_STACK_STATES

/* #undef FCS_RCS_STATES */
/* #undef CARD_DEBUG_PRES */

/* The size of a single pack in alloc.c/alloc.h measured in 1024 chars. */
#define FCS_IA_PACK_SIZE 64

#ifndef FCS_FREECELL_ONLY
/* #undef FCS_FREECELL_ONLY */
#endif

/* #undef FCS_DISABLE_SIMPLE_SIMON */
/* #undef FCS_SINGLE_HARD_THREAD */
/* #undef FCS_WITHOUT_FC_PRO_MOVES_COUNT */
/* #undef FCS_WITHOUT_TRIM_MAX_STORED_STATES */
/*
 * Get rid of the visited_iter counter on each state's extra_info. It is
 * used a little for debugging, but otherwise is not needed for the run-time
 * operation.
 * */
/* #undef FCS_WITHOUT_VISITED_ITER */
/*
 * Disable the patsolve code at compile time in case it isn't wanted.
 * */
#ifndef FCS_DISABLE_PATSOLVE
/* #undef FCS_DISABLE_PATSOLVE */
#endif
/*
 * Get rid of the "depth" field on each state's extra_info. It is
 * used a little, but otherwise is not needed for the run-time
 * operation.
 * */
/* #undef FCS_HARD_CODE_STATE_DEPTH_FIELD */
/* #undef FCS_WITHOUT_DEPTH_FIELD */
/* #undef FCS_WITHOUT_CMD_LINE_HELP */
/* #undef FCS_WITHOUT_ITER_HANDLER */
/* #undef FCS_WITHOUT_MAX_NUM_STATES */
/* #undef FCS_DISABLE_MULTI_FLARES */
/* #undef FCS_DISABLE_MULTI_NEXT_INSTS */
/* #undef FCS_DISABLE_MOVES_TRACKING */
/* #undef FCS_DISABLE_NUM_STORED_STATES */
/* #undef FCS_WITHOUT_EXPORTED_RESUME_SOLUTION */
/* #undef FCS_DISABLE_STATE_VALIDITY_CHECK */
/* #undef FCS_ENABLE_PRUNE__R_TF__UNCOND */
/* #undef FCS_USE_PRECOMPILED_CMD_LINE_THEME */
/* #undef FCS_RANGE_SOLVERS_PRINT_SOLVED */
/* #undef FCS_UNSAFE */
/*
 * This flag controls a hash behaviour. It seems to improve things somewhat.
 * */
#define FCS_INLINED_HASH_COMPARISON ON
#define FCS_INT_BIT_SIZE_LOG2 5
#define FCS_WITH_CONTEXT_VARIABLE
/* This is an integer that specifies the maximal size of identifiers
 * in chars/bytes. */
#define FCS_MAX_IDENT_LEN 10
/*
 * The size of void*.
 */
#define SIZEOF_VOID_P 8

// This flag determines whether we are using the more compact but slower,
// internal move tokens.
/* #undef FCS_USE_COMPACT_MOVE_TOKENS */
#define FCS_HARD_CODED_NUM_FCS_FOR_FREECELL_ONLY 4

#ifndef FCS_HARD_CODED_NUM_FCS_FOR_FREECELL_ONLY
#define FCS_HARD_CODED_NUM_FCS_FOR_FREECELL_ONLY 4
#endif

#ifndef FCS_HARD_CODE_SCANS_SYNERGY_AS_TRUE
/* #undef FCS_HARD_CODE_SCANS_SYNERGY_AS_TRUE */
#endif

#ifndef FCS_HARD_CODE_REPARENT_STATES_AS_FALSE
/* #undef FCS_HARD_CODE_REPARENT_STATES_AS_FALSE */
#endif

#ifndef FCS_HARD_CODE_CALC_REAL_DEPTH_AS_FALSE
/* #undef FCS_HARD_CODE_CALC_REAL_DEPTH_AS_FALSE */
#endif

#ifdef FCS_FREECELL_ONLY
#define HARD_CODED_NUM_FREECELLS FCS_HARD_CODED_NUM_FCS_FOR_FREECELL_ONLY
#define HARD_CODED_NUM_STACKS 8
#define HARD_CODED_NUM_DECKS 1
#endif

#ifdef HARD_CODED_NUM_FREECELLS
#define MAX_NUM_FREECELLS HARD_CODED_NUM_FREECELLS
#else
#define MAX_NUM_FREECELLS 8
#endif

#define FCS_DBM_FREECELLS_NUM 2
/* #undef FCS_DBM__STORE_KEYS_ONLY */

#ifdef HARD_CODED_NUM_STACKS
#define MAX_NUM_STACKS HARD_CODED_NUM_STACKS
#else
#define MAX_NUM_STACKS 13
#endif

#define MAX_NUM_INITIAL_CARDS_IN_A_STACK 8

#ifdef HARD_CODED_NUM_DECKS
#define MAX_NUM_DECKS HARD_CODED_NUM_DECKS
#else
#define MAX_NUM_DECKS 1
#endif


#define FCS_STATE_STORAGE_INDIRECT 0
#define FCS_STATE_STORAGE_INTERNAL_HASH 1
#define FCS_STATE_STORAGE_LIBAVL2_TREE 2
#define FCS_STATE_STORAGE_LIBREDBLACK_TREE 3
#define FCS_STATE_STORAGE_GLIB_TREE 4
#define FCS_STATE_STORAGE_GLIB_HASH 5
#define FCS_STATE_STORAGE_DB_FILE 6
#define FCS_STATE_STORAGE_JUDY 7
#define FCS_STATE_STORAGE_GOOGLE_DENSE_HASH 8
#define FCS_STATE_STORAGE_KAZ_TREE 9

#define FCS_STACK_STORAGE_NULL (-1)
#define FCS_STACK_STORAGE_INTERNAL_HASH 0
#define FCS_STACK_STORAGE_LIBAVL2_TREE 1
#define FCS_STACK_STORAGE_LIBREDBLACK_TREE 2
#define FCS_STACK_STORAGE_GLIB_TREE 3
#define FCS_STACK_STORAGE_GLIB_HASH 4
#define FCS_STACK_STORAGE_JUDY 5
#define FCS_STACK_STORAGE_GOOGLE_DENSE_HASH 6

#define FCS_STATE_STORAGE FCS_STATE_STORAGE_INTERNAL_HASH
#define FCS_STACK_STORAGE FCS_STACK_STORAGE_INTERNAL_HASH

#define FCS_RCS_CACHE_STORAGE_JUDY 0
#define FCS_RCS_CACHE_STORAGE_KAZ_TREE 1

#define FCS_RCS_CACHE_STORAGE FCS_RCS_CACHE_STORAGE_KAZ_TREE

/* #undef FCS_ZERO_FREECELLS_MODE */
/* #undef FC_SOLVE_INSTANCE_PARAMS_QUERYING */

#define HAVE_STRNCASECMP
#define HAVE_STRNDUP
#define HAVE_VASPRINTF
#define FCS_USE_INT128_FOR_VAR_BASE
#define FCS_CMD_LINE_ENABLE_INCREMENTAL_SOLVING 0

/* Version number of package */
#define VERSION "6.16.0"

#define FCS_WHICH_STATES_GOOGLE_HASH__DENSE  0
#define FCS_WHICH_STATES_GOOGLE_HASH__SPARSE 1

#define FCS_WHICH_COLUMNS_GOOGLE_HASH__DENSE  0
#define FCS_WHICH_COLUMNS_GOOGLE_HASH__SPARSE 1

#define FCS_WHICH_COLUMNS_GOOGLE_HASH FCS_WHICH_COLUMNS_GOOGLE_HASH__SPARSE
#define FCS_WHICH_STATES_GOOGLE_HASH FCS_WHICH_STATES_GOOGLE_HASH__SPARSE

// How many ranks there are - Ace to King == 13.
#define FCS_MAX_RANK 13
#ifdef __cplusplus
};
#endif
