/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.pdb.classtype.Access;
import ghidra.app.util.pdb.classtype.Property;
import java.util.Objects;

public class ClassFieldAttributes {
    private static final ClassFieldAttributes[][] all = new ClassFieldAttributes[Access.values().length][Property.values().length];
    public static final ClassFieldAttributes UNKNOWN;
    public static final ClassFieldAttributes BLANK;
    private final Access access;
    private final Property property;

    public static ClassFieldAttributes get(Access access, Property property) {
        return all[access.ordinal()][property.ordinal()];
    }

    public static ClassFieldAttributes convert(ClassFieldMsAttributes msAtts, Access defaultAccess) {
        Access myAccess = switch (msAtts.getAccess()) {
            case ClassFieldMsAttributes.Access.PUBLIC -> Access.PUBLIC;
            case ClassFieldMsAttributes.Access.PROTECTED -> Access.PROTECTED;
            case ClassFieldMsAttributes.Access.PRIVATE -> Access.PRIVATE;
            case ClassFieldMsAttributes.Access.BLANK -> defaultAccess;
            default -> Access.UNKNOWN;
        };
        Property myProperty = switch (msAtts.getProperty()) {
            case ClassFieldMsAttributes.Property.VIRTUAL -> Property.VIRTUAL;
            case ClassFieldMsAttributes.Property.INTRO -> Property.VIRTUAL;
            case ClassFieldMsAttributes.Property.INTRO_PURE -> Property.VIRTUAL;
            case ClassFieldMsAttributes.Property.STATIC -> Property.STATIC;
            case ClassFieldMsAttributes.Property.FRIEND -> Property.FRIEND;
            case ClassFieldMsAttributes.Property.BLANK -> Property.BLANK;
            default -> Property.UNKNOWN;
        };
        return ClassFieldAttributes.get(myAccess, myProperty);
    }

    private ClassFieldAttributes(Access access, Property property) {
        this.access = access;
        this.property = property;
    }

    public Access getAccess() {
        return this.access;
    }

    public Property getProperty() {
        return this.property;
    }

    public void emit(StringBuilder builder) {
        StringBuilder myBuilder = new StringBuilder();
        if (this.access.getValue() > Access.BLANK.getValue()) {
            myBuilder.append((Object)this.access);
            myBuilder.append(' ');
        }
        if (this.property.getValue() > Property.BLANK.getValue()) {
            myBuilder.append((Object)this.property);
            myBuilder.append(' ');
        }
        builder.append((CharSequence)myBuilder);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.emit(builder);
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.access, this.property});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassFieldAttributes other = (ClassFieldAttributes)obj;
        return this.access == other.access && this.property == other.property;
    }

    static {
        for (Access access : Access.values()) {
            for (Property property : Property.values()) {
                ClassFieldAttributes.all[access.ordinal()][property.ordinal()] = new ClassFieldAttributes(access, property);
            }
        }
        UNKNOWN = ClassFieldAttributes.get(Access.UNKNOWN, Property.UNKNOWN);
        BLANK = ClassFieldAttributes.get(Access.BLANK, Property.BLANK);
    }
}

