/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.AoutHeader;
import ghidra.app.util.bin.format.coff.AoutHeaderFactory;
import ghidra.app.util.bin.format.coff.CoffException;
import ghidra.app.util.bin.format.coff.CoffMachineType;
import ghidra.app.util.bin.format.coff.CoffSectionHeader;
import ghidra.app.util.bin.format.coff.CoffSectionHeaderFactory;
import ghidra.app.util.bin.format.coff.CoffSymbol;
import ghidra.app.util.bin.format.coff.CoffSymbolAux;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CoffFileHeader
implements StructConverter {
    private short f_magic;
    private short f_nscns;
    private int f_timdat;
    private int f_symptr;
    private int f_nsyms;
    private short f_opthdr;
    private short f_flags;
    private short f_target_id;
    private BinaryReader reader;
    private AoutHeader _aoutHeader;
    private List<CoffSectionHeader> _sections = new ArrayList<CoffSectionHeader>();
    private List<CoffSymbol> _symbols = new ArrayList<CoffSymbol>();

    public CoffFileHeader(ByteProvider provider) throws IOException, CoffException {
        this.reader = new BinaryReader(provider, true);
        if (!this.isValid()) {
            this.reader = new BinaryReader(provider, false);
            if (!this.isValid()) {
                throw new CoffException("Not a valid COFF file");
            }
        }
        this.f_magic = this.reader.readNextShort();
        this.f_nscns = this.reader.readNextShort();
        this.f_timdat = this.reader.readNextInt();
        this.f_symptr = this.reader.readNextInt();
        this.f_nsyms = this.reader.readNextInt();
        this.f_opthdr = this.reader.readNextShort();
        this.f_flags = this.reader.readNextShort();
        if (this.isCoffLevelOneOrTwo()) {
            this.f_target_id = this.reader.readNextShort();
        }
    }

    private boolean isCoffLevelOneOrTwo() {
        return this.f_magic == 193 || this.f_magic == 194;
    }

    public short getMagic() {
        return this.f_magic;
    }

    public short getSectionCount() {
        return this.f_nscns;
    }

    public int getTimestamp() {
        return this.f_timdat;
    }

    public int getSymbolTablePointer() {
        return this.f_symptr;
    }

    public int getSymbolTableEntries() {
        return this.f_nsyms;
    }

    public short getOptionalHeaderSize() {
        return this.f_opthdr;
    }

    public short getFlags() {
        return this.f_flags;
    }

    public short getTargetID() throws CoffException {
        if (!this.isCoffLevelOneOrTwo()) {
            throw new CoffException("Calling this method is not valid for this COFF header type.");
        }
        return this.f_target_id;
    }

    public long getImageBase(boolean isWindowsPlatform) {
        if (isWindowsPlatform && this.f_opthdr != 0) {
            return 128L;
        }
        return 0L;
    }

    public String getMachineName() {
        if (this.isCoffLevelOneOrTwo()) {
            return "" + this.f_target_id;
        }
        return "" + this.f_magic;
    }

    public short getMachine() {
        if (this.isCoffLevelOneOrTwo()) {
            return this.f_target_id;
        }
        return this.f_magic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseSectionHeaders() throws IOException {
        long originalIndex = this.reader.getPointerIndex();
        try {
            this.reader.setPointerIndex(this.sizeof() + this.f_opthdr);
            for (int i = 0; i < this.f_nscns; ++i) {
                CoffSectionHeader section = CoffSectionHeaderFactory.createSectionHeader(this.reader, this);
                this._sections.add(section);
            }
        }
        finally {
            this.reader.setPointerIndex(originalIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(TaskMonitor monitor) throws IOException {
        monitor.setMessage("Completing file header parsing...");
        long originalIndex = this.reader.getPointerIndex();
        try {
            int i;
            this.reader.setPointerIndex(this.sizeof());
            this._aoutHeader = AoutHeaderFactory.createAoutHeader(this.reader, this);
            this.reader.setPointerIndex(this.sizeof() + this.f_opthdr);
            for (i = 0; i < this.f_nscns; ++i) {
                CoffSectionHeader section = CoffSectionHeaderFactory.createSectionHeader(this.reader, this);
                this._sections.add(section);
                section.parse(this.reader, this, monitor);
            }
            this.reader.setPointerIndex(this.f_symptr);
            for (i = 0; i < this.f_nsyms; ++i) {
                CoffSymbol symbol = new CoffSymbol(this.reader, this);
                this._symbols.add(symbol);
                i += symbol.getAuxiliaryCount();
            }
        }
        finally {
            this.reader.setPointerIndex(originalIndex);
        }
    }

    public List<CoffSectionHeader> getSections() {
        return this._sections;
    }

    public List<CoffSymbol> getSymbols() {
        return this._symbols;
    }

    public CoffSymbol getSymbolAtIndex(long index) {
        int actualIndex = 0;
        for (CoffSymbol symbol : this._symbols) {
            if ((long)actualIndex == index) {
                return symbol;
            }
            ++actualIndex;
            for (CoffSymbolAux auxSymbol : symbol.getAuxiliarySymbols()) {
                if (auxSymbol == null) {
                    // empty if block
                }
                ++actualIndex;
            }
        }
        return null;
    }

    public int sizeof() {
        if (this.isCoffLevelOneOrTwo()) {
            return 22;
        }
        return 20;
    }

    public AoutHeader getOptionalHeader() {
        return this._aoutHeader;
    }

    public boolean isValid() throws IOException {
        int MIN_BYTE_LENGTH = 22;
        int COFF_NULL_SANITY_CHECK_LEN = 64;
        if (this.reader.length() < 22L) {
            return false;
        }
        short magic = this.reader.readShort(0L);
        if (magic == 0 && this.reader.length() > 64L) {
            byte[] headerBytes = this.reader.readByteArray(0L, 64);
            boolean allZeros = true;
            for (byte b : headerBytes) {
                boolean bl = allZeros = b == 0;
                if (!allZeros) break;
            }
            if (allZeros) {
                return false;
            }
        }
        return CoffMachineType.isMachineTypeDefined(magic);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(StructConverterUtil.parseName(this.getClass()), 0);
        struct.add(WORD, "f_magic", null);
        struct.add(WORD, "f_nscns", null);
        struct.add(DWORD, "f_timdat", null);
        struct.add(DWORD, "f_symptr", null);
        struct.add(DWORD, "f_nsyms", null);
        struct.add(WORD, "f_opthdr", null);
        struct.add(WORD, "f_flags", null);
        if (this.isCoffLevelOneOrTwo()) {
            struct.add(WORD, "f_target_id", null);
        }
        return struct;
    }
}

