/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableAssemblyRefOS
extends CliAbstractTable {
    public CliTableAssemblyRefOS(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliAssemblyRefOSRow(this, reader.readNextInt(), reader.readNextInt(), reader.readNextInt(), this.readTableIndex(reader, CliTypeTable.AssemblyRef)));
        }
    }

    @Override
    public DataType getRowDataType() {
        return this.toDataType();
    }

    @Override
    public DataType toDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "AssemblyRefOS Row", 0);
        rowDt.add(DWORD, "OSPlatformID", null);
        rowDt.add(DWORD, "OSMajorVersion", null);
        rowDt.add(DWORD, "OSMinorVersion", null);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.AssemblyRef), "AssemblyRef", "index into AssemblyRef table");
        return new ArrayDataType((DataType)rowDt, this.numRows, rowDt.getLength());
    }

    public class CliAssemblyRefOSRow
    extends CliAbstractTableRow {
        public int osPlatformID;
        public int osMajorVersion;
        public int osMinorVersion;
        public int assemblyRefIndex;

        public CliAssemblyRefOSRow(CliTableAssemblyRefOS this$0, int osPlatformID, int osMajorVersion, int osMinorVersion, int assemblyRefIndex) {
            this.osPlatformID = osPlatformID;
            this.osMajorVersion = osMajorVersion;
            this.osMinorVersion = osMinorVersion;
            this.assemblyRefIndex = assemblyRefIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("%d v%d.%d", this.osPlatformID, this.osMajorVersion, this.osMinorVersion);
        }
    }
}

