/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import ghidra.features.base.memsearch.format.SearchFormat;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SearchHistory {
    private List<ByteMatcher> history = new LinkedList<ByteMatcher>();
    private int maxHistory;

    public SearchHistory(int maxHistory) {
        this.maxHistory = maxHistory;
    }

    public SearchHistory(SearchHistory other) {
        this.history = new LinkedList<ByteMatcher>(other.history);
        this.maxHistory = other.maxHistory;
    }

    public void addSearch(ByteMatcher matcher) {
        this.removeSimilarMatchers(matcher);
        this.history.addFirst(matcher);
        this.truncateHistoryAsNeeded();
    }

    private void removeSimilarMatchers(ByteMatcher matcher) {
        Iterator<ByteMatcher> it = this.history.iterator();
        String newInput = matcher.getInput();
        SearchFormat newFormat = matcher.getSettings().getSearchFormat();
        while (it.hasNext()) {
            ByteMatcher historyMatch = it.next();
            SearchFormat historyFormat = historyMatch.getSettings().getSearchFormat();
            String historyInput = historyMatch.getInput();
            if (!historyFormat.equals(newFormat) || !historyInput.equals(newInput)) continue;
            it.remove();
        }
    }

    private void truncateHistoryAsNeeded() {
        int historySize = this.history.size();
        if (historySize > this.maxHistory) {
            int numToRemove = historySize - this.maxHistory;
            for (int i = 0; i < numToRemove; ++i) {
                this.history.remove(this.history.size() - 1);
            }
        }
    }

    public ByteMatcher[] getHistoryAsArray() {
        ByteMatcher[] historyArray = new ByteMatcher[this.history.size()];
        this.history.toArray(historyArray);
        return historyArray;
    }
}

