/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.searcher;

import ghidra.features.base.memsearch.bytesequence.AddressableByteSequence;
import ghidra.features.base.memsearch.bytesequence.ByteSequence;
import ghidra.features.base.memsearch.bytesequence.ExtendedByteSequence;
import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeSplitter;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.task.TaskMonitor;
import java.util.function.Predicate;

public class MemorySearcher {
    private static final int DEFAULT_CHUNK_SIZE = 16384;
    private static final int OVERLAP_SIZE = 100;
    private final AddressableByteSequence bytes1;
    private final AddressableByteSequence bytes2;
    private final ByteMatcher matcher;
    private final int chunkSize;
    private Predicate<MemoryMatch> filter = r -> true;
    private final int searchLimit;
    private final AddressSetView searchSet;

    public MemorySearcher(AddressableByteSource byteSource, ByteMatcher matcher, AddressSetView addresses, int searchLimit) {
        this(byteSource, matcher, addresses, searchLimit, 16384);
    }

    public MemorySearcher(AddressableByteSource byteSource, ByteMatcher matcher, AddressSetView addresses, int searchLimit, int chunkSize) {
        this.matcher = matcher;
        this.searchSet = addresses;
        this.searchLimit = searchLimit;
        this.chunkSize = chunkSize;
        this.bytes1 = new AddressableByteSequence(byteSource, chunkSize);
        this.bytes2 = new AddressableByteSequence(byteSource, chunkSize);
    }

    public void setMatchFilter(Predicate<MemoryMatch> filter) {
        this.filter = filter;
    }

    public boolean findAll(Accumulator<MemoryMatch> accumulator, TaskMonitor monitor) {
        monitor.initialize(this.searchSet.getNumAddresses(), "Searching...");
        for (AddressRange range : this.searchSet.getAddressRanges()) {
            if (this.findAll(accumulator, range, monitor)) continue;
            return false;
        }
        return true;
    }

    public MemoryMatch findOnce(Address start, boolean forward, TaskMonitor monitor) {
        if (forward) {
            return this.findNext(start, monitor);
        }
        return this.findPrevious(start, monitor);
    }

    public MemoryMatch findNext(Address start, TaskMonitor monitor) {
        long numAddresses = this.searchSet.getNumAddresses() - this.searchSet.getAddressCountBefore(start);
        monitor.initialize(numAddresses, "Searching....");
        for (AddressRange range : this.searchSet.getAddressRanges(start, true)) {
            MemoryMatch match = this.findFirst(range = range.intersectRange(start, range.getMaxAddress()), monitor);
            if (match != null) {
                return match;
            }
            if (!monitor.isCancelled()) continue;
            break;
        }
        return null;
    }

    public MemoryMatch findPrevious(Address start, TaskMonitor monitor) {
        monitor.initialize(this.searchSet.getAddressCountBefore(start) + 1L, "Searching....");
        for (AddressRange range : this.searchSet.getAddressRanges(start, false)) {
            MemoryMatch match = this.findLast(range, start, monitor);
            if (match != null) {
                return match;
            }
            if (!monitor.isCancelled()) continue;
            break;
        }
        return null;
    }

    private MemoryMatch findFirst(AddressRange range, TaskMonitor monitor) {
        AddressableByteSequence searchBytes = this.bytes1;
        AddressableByteSequence extra = this.bytes2;
        AddressRangeSplitter it = new AddressRangeSplitter(range, this.chunkSize, true);
        AddressRange first = (AddressRange)it.next();
        searchBytes.setRange(first);
        while (it.hasNext()) {
            AddressRange next = (AddressRange)it.next();
            extra.setRange(next);
            MemoryMatch match = this.findFirst(searchBytes, extra, monitor);
            if (match != null) {
                return match;
            }
            if (monitor.isCancelled()) break;
            searchBytes = extra;
            extra = searchBytes == this.bytes1 ? this.bytes2 : this.bytes1;
        }
        extra.clear();
        return this.findFirst(searchBytes, extra, monitor);
    }

    private MemoryMatch findLast(AddressRange range, Address start, TaskMonitor monitor) {
        AddressableByteSequence searchBytes = this.bytes1;
        AddressableByteSequence extra = this.bytes2;
        extra.clear();
        if (range.contains(start)) {
            Address min = range.getMinAddress();
            Address max = range.getMaxAddress();
            range = new AddressRangeImpl(min, start);
            AddressRangeImpl remaining = new AddressRangeImpl(start.next(), max);
            AddressRange extraRange = new AddressRangeSplitter((AddressRange)remaining, this.chunkSize, true).next();
            extra.setRange(extraRange);
        }
        AddressRangeSplitter it = new AddressRangeSplitter(range, this.chunkSize, false);
        while (it.hasNext()) {
            AddressRange next = (AddressRange)it.next();
            searchBytes.setRange(next);
            MemoryMatch match = this.findLast(searchBytes, extra, monitor);
            if (match != null) {
                return match;
            }
            if (monitor.isCancelled()) break;
            extra = searchBytes;
            searchBytes = extra == this.bytes1 ? this.bytes2 : this.bytes1;
        }
        return null;
    }

    private MemoryMatch findFirst(AddressableByteSequence searchBytes, ByteSequence extra, TaskMonitor monitor) {
        ExtendedByteSequence searchSequence = new ExtendedByteSequence(searchBytes, extra, 100);
        for (ByteMatcher.ByteMatch byteMatch : this.matcher.match(searchSequence)) {
            byte[] bytes;
            Address address = searchBytes.getAddress(byteMatch.start());
            MemoryMatch match = new MemoryMatch(address, bytes = searchSequence.getBytes(byteMatch.start(), byteMatch.length()), byteMatch.matcher());
            if (this.filter.test(match)) {
                return match;
            }
            if (!monitor.isCancelled()) continue;
            break;
        }
        monitor.incrementProgress((long)searchBytes.getLength());
        return null;
    }

    private MemoryMatch findLast(AddressableByteSequence searchBytes, ByteSequence extra, TaskMonitor monitor) {
        MemoryMatch last = null;
        ExtendedByteSequence searchSequence = new ExtendedByteSequence(searchBytes, extra, 100);
        for (ByteMatcher.ByteMatch byteMatch : this.matcher.match(searchSequence)) {
            byte[] bytes;
            Address address = searchBytes.getAddress(byteMatch.start());
            MemoryMatch match = new MemoryMatch(address, bytes = searchSequence.getBytes(byteMatch.start(), byteMatch.length()), byteMatch.matcher());
            if (this.filter.test(match)) {
                last = match;
            }
            if (!monitor.isCancelled()) continue;
            return null;
        }
        monitor.incrementProgress((long)searchBytes.getLength());
        return last;
    }

    private boolean findAll(Accumulator<MemoryMatch> accumulator, AddressRange range, TaskMonitor monitor) {
        AddressableByteSequence searchBytes = this.bytes1;
        AddressableByteSequence extra = this.bytes2;
        AddressRangeSplitter it = new AddressRangeSplitter(range, this.chunkSize, true);
        AddressRange first = (AddressRange)it.next();
        searchBytes.setRange(first);
        while (it.hasNext()) {
            AddressRange next = (AddressRange)it.next();
            extra.setRange(next);
            if (!this.findAll(accumulator, searchBytes, extra, monitor)) {
                return false;
            }
            searchBytes = extra;
            extra = searchBytes == this.bytes1 ? this.bytes2 : this.bytes1;
        }
        extra.clear();
        return this.findAll(accumulator, searchBytes, extra, monitor);
    }

    private boolean findAll(Accumulator<MemoryMatch> accumulator, AddressableByteSequence searchBytes, ByteSequence extra, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return false;
        }
        ExtendedByteSequence searchSequence = new ExtendedByteSequence(searchBytes, extra, 100);
        for (ByteMatcher.ByteMatch byteMatch : this.matcher.match(searchSequence)) {
            byte[] bytes;
            Address address = searchBytes.getAddress(byteMatch.start());
            MemoryMatch match = new MemoryMatch(address, bytes = searchSequence.getBytes(byteMatch.start(), byteMatch.length()), byteMatch.matcher());
            if (this.filter.test(match)) {
                if (accumulator.size() >= this.searchLimit) {
                    return false;
                }
                accumulator.add((Object)match);
            }
            if (!monitor.isCancelled()) continue;
            return false;
        }
        monitor.setMessage("Searching...");
        monitor.incrementProgress((long)searchBytes.getLength());
        return true;
    }
}

