/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.action.DockingAction;

public abstract class ContextSpecificAction<T>
extends DockingAction {
    private Class<T> contextClass;

    public ContextSpecificAction(String name, String owner, Class<T> contextClass) {
        super(name, owner);
        this.contextClass = contextClass;
    }

    @Override
    public boolean isEnabledForContext(ActionContext actionContext) {
        if (this.contextClass.isInstance(actionContext)) {
            return this.isEnabledForContext(this.contextClass.cast(actionContext));
        }
        return false;
    }

    @Override
    public boolean isValidContext(ActionContext actionContext) {
        if (this.contextClass.isInstance(actionContext)) {
            return this.isValidContext(this.contextClass.cast(actionContext));
        }
        return false;
    }

    @Override
    public boolean isAddToPopup(ActionContext actionContext) {
        if (this.contextClass.isInstance(actionContext)) {
            return this.isAddToPopup(this.contextClass.cast(actionContext));
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionContext actionContext) {
        this.actionPerformed(this.contextClass.cast(actionContext));
    }

    protected abstract void actionPerformed(T var1);

    protected boolean isAddToPopup(T context) {
        return this.isEnabledForContext(context);
    }

    protected boolean isEnabledForContext(T context) {
        return true;
    }

    protected boolean isValidContext(T context) {
        return true;
    }
}

