/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.listener.ViewListener;
import docking.widgets.fieldpanel.support.ViewerPosition;
import java.math.BigInteger;

public class FieldPanelScrollCoordinator
implements ViewListener {
    FieldPanel[] panels;
    boolean valuesChanging;

    public FieldPanelScrollCoordinator(FieldPanel[] panels) {
        this.panels = new FieldPanel[panels.length];
        System.arraycopy(panels, 0, this.panels, 0, panels.length);
        for (FieldPanel panel : panels) {
            this.addListeners(panel);
        }
    }

    protected FieldPanel getOtherPanel(FieldPanel fp) {
        if (this.panels[0] == fp) {
            return this.panels[1];
        }
        return this.panels[0];
    }

    public void dispose() {
        for (FieldPanel panel : this.panels) {
            this.removeListeners(panel);
        }
        this.panels = null;
    }

    public void add(FieldPanel fp) {
        this.addListeners(fp);
        FieldPanel[] newPanels = new FieldPanel[this.panels.length + 1];
        System.arraycopy(this.panels, 0, newPanels, 0, this.panels.length);
        newPanels[this.panels.length] = fp;
        this.panels = newPanels;
        ViewerPosition vp = fp.getViewerPosition();
        this.viewChanged(fp, vp.getIndex(), vp.getXOffset(), vp.getYOffset());
    }

    public void remove(FieldPanel fp) {
        this.removeListeners(fp);
        FieldPanel[] newPanels = new FieldPanel[this.panels.length - 1];
        int j = 0;
        for (FieldPanel panel : this.panels) {
            if (panel == fp) continue;
            newPanels[j++] = panel;
        }
        this.panels = newPanels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChanged(FieldPanel fp, BigInteger index, int xPos, int yPos) {
        if (this.valuesChanging) {
            return;
        }
        this.valuesChanging = true;
        try {
            for (FieldPanel panel : this.panels) {
                if (panel == fp) continue;
                panel.setViewerPosition(index, xPos, yPos);
            }
        }
        finally {
            this.valuesChanging = false;
        }
    }

    private void addListeners(FieldPanel fp) {
        fp.addViewListener(this);
    }

    private void removeListeners(FieldPanel fp) {
        fp.removeViewListener(this);
    }
}

