/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.trace.database.listing;

import ghidra.program.model.address.*;
import ghidra.trace.model.listing.*;

/**
 * The implementation of {@link TraceCodeManager#codeUnits()}
 */
public class DBTraceCodeUnitsMemoryView extends
		AbstractWithUndefinedDBTraceCodeUnitsMemoryView<DBTraceCodeUnitAdapter, DBTraceCodeUnitsView>
		implements TraceCodeUnitsView, InternalBaseCodeUnitsView<TraceCodeUnit> {

	/**
	 * Construct the view
	 * 
	 * @param manager the manager
	 */
	public DBTraceCodeUnitsMemoryView(DBTraceCodeManager manager) {
		super(manager);
	}

	@Override
	protected DBTraceCodeUnitsView getView(DBTraceCodeSpace space) {
		return space.codeUnits;
	}

	@Override
	public AddressSetView getAddressSetView(long snap, AddressRange within) {
		return new AddressSet(within);
	}
}
