/* ###
 * IP: GHIDRA
 * REVIEWED: YES
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.plugin.core.compositeeditor;


/**
 * Composite Viewer Model change listener interface.
 */
public interface CompositeViewerModelListener {

	/**
	 * Called whenever the composite's component data is changed.
	 */
	public abstract void componentDataChanged();
	
	/**
	 * Called whenever the composite's non-component data is changed.
	 * For example, the composite's name, description, size, ...
	 */
	public abstract void compositeInfoChanged();

	/**
	 * Notification that the CompositeViewerModel's status information has changed.
	 *
	 * @param message the information to provide to the user.
	 * @param beep true indicates an audible beep is suggested.
	 */
	public abstract void statusChanged(String message, boolean beep);

	/**
	 * Called to indicate the model's component selection has changed.
	 */
	public abstract void selectionChanged();
}
