---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Expression Language Injection
---

## Description

It is possible to execute arbitrary Expression Language (EL) statements on the target
application server. EL injection is a critical severity vulnerability that can lead to
full system compromise. EL injection can occur when attacker-controlled data is used to construct
EL statements without neutralizing special characters. These special characters could modify the
intended EL statement prior to it being executed by an interpreter.

## Remediation

User-controlled data should always have special elements neutralized when used as part of
constructing Expression Language statements. Please consult the documentation for the EL
interpreter in use on how properly neutralize user controlled data.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 917.1 | false | 917 | Active | high |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/917.html)
- [OWASP](https://owasp.org/www-community/vulnerabilities/Expression_Language_Injection)
- [Expression Language Injection [PDF]](https://mindedsecurity.com/wp-content/uploads/2020/10/ExpressionLanguageInjection.pdf)
