/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.util.function.Consumer;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.UnpackingVisitor;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ProviderResolutionStrategy;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.internal.PatternSetFactory;
import org.gradle.internal.file.PathToFileResolver;

public class ProviderBackedFileCollection
extends CompositeFileCollection {
    private final ProviderInternal<?> provider;
    private final PathToFileResolver resolver;
    private final ProviderResolutionStrategy providerResolutionStrategy;

    public ProviderBackedFileCollection(ProviderInternal<?> provider, PathToFileResolver resolver, TaskDependencyFactory taskDependencyFactory, PatternSetFactory patternSetFactory, ProviderResolutionStrategy providerResolutionStrategy) {
        super(taskDependencyFactory, patternSetFactory);
        this.provider = provider;
        this.resolver = resolver;
        this.providerResolutionStrategy = providerResolutionStrategy;
    }

    @Override
    public String getDisplayName() {
        return "file collection";
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        ValueSupplier.ValueProducer producer = this.provider.getProducer();
        if (producer.isKnown()) {
            producer.visitDependencies(context);
        } else {
            UnpackingVisitor unpackingVisitor = new UnpackingVisitor(arg_0 -> ((TaskDependencyResolveContext)context).add(arg_0), this.resolver, this.taskDependencyFactory, this.patternSetFactory);
            unpackingVisitor.add(this.providerResolutionStrategy.resolve(this.provider));
        }
    }

    @Override
    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        UnpackingVisitor unpackingVisitor = new UnpackingVisitor(visitor, this.resolver, this.taskDependencyFactory, this.patternSetFactory);
        unpackingVisitor.add(this.providerResolutionStrategy.resolve(this.provider));
    }

    public ProviderInternal<?> getProvider() {
        return this.provider;
    }

    public PathToFileResolver getResolver() {
        return this.resolver;
    }
}

