/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.DigestException;
import sun.security.jca.JCAUtil;

public abstract class MessageDigestSpi {
    private byte[] tempArray;

    protected int engineGetDigestLength() {
        return 0;
    }

    protected abstract void engineUpdate(byte var1);

    protected abstract void engineUpdate(byte[] var1, int var2, int var3);

    protected void engineUpdate(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        if (byteBuffer.hasArray()) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset();
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit();
            this.engineUpdate(byArray, n + n2, n3 - n2);
            byteBuffer.position(n3);
        } else {
            int n = byteBuffer.remaining();
            int n4 = JCAUtil.getTempArraySize(n);
            if (this.tempArray == null || n4 > this.tempArray.length) {
                this.tempArray = new byte[n4];
            }
            while (n > 0) {
                int n5 = Math.min(n, this.tempArray.length);
                byteBuffer.get(this.tempArray, 0, n5);
                this.engineUpdate(this.tempArray, 0, n5);
                n -= n5;
            }
        }
    }

    protected abstract byte[] engineDigest();

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        byte[] byArray2 = this.engineDigest();
        if (n2 < byArray2.length) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n < byArray2.length) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    protected abstract void engineReset();

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }
}

