/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import liquibase.exception.CustomChangeException;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Table;
import org.keycloak.common.util.Time;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate4_7_0_OfflineSessionsTimestamps
extends CustomKeycloakTask {
    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        String offlineUserSessionsTableName = this.database.correctObjectName("OFFLINE_USER_SESSION", Table.class);
        try {
            int currentTime = Time.currentTime();
            UpdateStatement updateStatement = new UpdateStatement(null, null, offlineUserSessionsTableName).addNewColumnValue("LAST_SESSION_REFRESH", (Object)currentTime);
            this.statements.add(updateStatement);
            this.confirmationMessage.append("Updated column LAST_SESSION_REFRESH in OFFLINE_USER_SESSION table with time " + currentTime);
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Update 4.7.0.Final";
    }
}

