/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.BackupAckCommand;
import org.infinispan.commands.write.BackupMultiKeyAckCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.TriangleOrderManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.DefaultTopologyRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.DefaultReadyAction;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;
import org.infinispan.remoting.inboundhandler.action.TriangleOrderAction;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TrianglePerCacheInboundInvocationHandler
extends BasePerCacheInboundInvocationHandler {
    private static final Log log = LogFactory.getLog(TrianglePerCacheInboundInvocationHandler.class);
    @Inject
    TriangleOrderManager triangleOrderManager;
    @Inject
    CommandAckCollector commandAckCollector;
    @Inject
    CommandsFactory commandsFactory;
    private Address localAddress;
    private boolean asyncCache;

    @Override
    public void start() {
        super.start();
        this.localAddress = this.rpcManager.getAddress();
        this.asyncCache = !this.configuration.clustering().cacheMode().isSynchronous();
    }

    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        try {
            switch (command.getCommandId()) {
                case 1: {
                    this.handleSingleRpcCommand((SingleRpcCommand)command, reply, order);
                    return;
                }
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: {
                    this.handleBackupWriteCommand((BackupWriteCommand)command);
                    return;
                }
                case 41: 
                case 42: {
                    this.handleBackupAckCommand((BackupAckCommand)command);
                    return;
                }
                case 112: 
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    this.handleStateRequestCommand(command, reply, order);
                    return;
                }
            }
            this.handleDefaultCommand(command, reply, order);
        }
        catch (Throwable throwable) {
            reply.reply(TrianglePerCacheInboundInvocationHandler.exceptionHandlingCommand(command, throwable));
        }
    }

    public TriangleOrderManager getTriangleOrderManager() {
        return this.triangleOrderManager;
    }

    private void handleStateRequestCommand(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        if (TrianglePerCacheInboundInvocationHandler.executeOnExecutorService(order, command)) {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.READY_TOPOLOGY, order.preserveOrder());
            this.blockingExecutor.execute(runnable);
        } else {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.WAIT_TOPOLOGY, order.preserveOrder());
            runnable.run();
        }
    }

    private void handleDefaultCommand(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        if (TrianglePerCacheInboundInvocationHandler.executeOnExecutorService(order, command)) {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.READY_TX_DATA, order.preserveOrder());
            this.blockingExecutor.execute(runnable);
        } else {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.WAIT_TX_DATA, order.preserveOrder());
            runnable.run();
        }
    }

    private void handleBackupWriteCommand(BackupWriteCommand command) {
        int topologyId = command.getTopologyId();
        ReadyAction readyAction = this.createTriangleOrderAction(command, topologyId, command.getSequence(), command.getSegmentId());
        BlockingRunnable runnable = this.createBackupWriteRunnable(command, topologyId, readyAction);
        this.nonBlockingExecutor.execute(runnable);
    }

    private void handleBackupAckCommand(BackupAckCommand command) {
        command.ack(this.commandAckCollector);
    }

    private void handleSingleRpcCommand(SingleRpcCommand command, Reply reply, DeliverOrder order) {
        if (TrianglePerCacheInboundInvocationHandler.executeOnExecutorService(order, command)) {
            int commandTopologyId = TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId((CacheRpcCommand)command);
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, commandTopologyId, TopologyMode.READY_TX_DATA, order.preserveOrder());
            this.blockingExecutor.execute(runnable);
        } else {
            this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId((CacheRpcCommand)command), TopologyMode.WAIT_TX_DATA, order.preserveOrder()).run();
        }
    }

    private void sendExceptionAck(CommandInvocationId id, Throwable throwable, int topologyId, long flagBitSet) {
        Address origin = id.getAddress();
        if (this.skipBackupAck(flagBitSet)) {
            if (log.isTraceEnabled()) {
                log.tracef("Skipping ack for command %s.", id);
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Sending exception ack for command %s. Originator=%s.", id, origin);
        }
        if (origin.equals(this.localAddress)) {
            this.commandAckCollector.completeExceptionally(id.getId(), throwable, topologyId);
        } else {
            this.rpcManager.sendTo(origin, this.commandsFactory.buildExceptionAckCommand(id.getId(), throwable, topologyId), DeliverOrder.NONE_NO_FC);
        }
    }

    private void onBackupException(BackupWriteCommand command, Throwable throwable, ReadyAction readyAction) {
        readyAction.onException();
        readyAction.onFinally();
        this.sendExceptionAck(command.getCommandInvocationId(), throwable, command.getTopologyId(), command.getFlags());
    }

    private void sendBackupAck(CommandInvocationId id, int topologyId, int segment, long flagBitSet) {
        Address origin = id.getAddress();
        if (this.skipBackupAck(flagBitSet)) {
            if (log.isTraceEnabled()) {
                log.tracef("Skipping ack for command %s.", id);
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Sending ack for command %s. Originator=%s.", id, origin);
        }
        if (id.getAddress().equals(this.localAddress)) {
            this.commandAckCollector.backupAck(id.getId(), this.localAddress, segment, topologyId);
        } else {
            BackupMultiKeyAckCommand command = this.commandsFactory.buildBackupMultiKeyAckCommand(id.getId(), segment, topologyId);
            this.rpcManager.sendTo(origin, command, DeliverOrder.NONE_NO_FC);
        }
    }

    private BlockingRunnable createBackupWriteRunnable(BackupWriteCommand command, int commandTopologyId, final ReadyAction readyAction) {
        readyAction.addListener(this::checkForReadyTasks);
        return new DefaultTopologyRunnable(this, this, command, Reply.NO_OP, TopologyMode.READY_TX_DATA, commandTopologyId, false){
            final /* synthetic */ TrianglePerCacheInboundInvocationHandler this$0;
            {
                this.this$0 = this$0;
                super(handler, command, reply, topologyMode, commandTopologyId, sync);
            }

            @Override
            public boolean isReady() {
                return super.isReady() && readyAction.isReady();
            }

            @Override
            protected void onException(Throwable throwable) {
                super.onException(throwable);
                this.this$0.onBackupException((BackupWriteCommand)this.command, throwable, readyAction);
            }

            @Override
            protected void afterInvoke() {
                super.afterInvoke();
                readyAction.onFinally();
                BackupWriteCommand backupCommand = (BackupWriteCommand)this.command;
                this.this$0.sendBackupAck(backupCommand.getCommandInvocationId(), this.commandTopologyId, backupCommand.getSegmentId(), backupCommand.getFlags());
            }
        };
    }

    private ReadyAction createTriangleOrderAction(ReplicableCommand command, int topologyId, long sequence, int segmentId) {
        return new DefaultReadyAction(new ActionState(command, topologyId), new TriangleOrderAction(this, sequence, segmentId));
    }

    private boolean skipBackupAck(long flagBitSet) {
        return EnumUtil.containsAll((long)flagBitSet, (long)FlagBitSets.FORCE_ASYNCHRONOUS) || this.asyncCache && !EnumUtil.containsAll((long)flagBitSet, (long)FlagBitSets.FORCE_SYNCHRONOUS);
    }
}

