/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CborConverter {
    private static final String INPUT_MISMATCH_ERROR_MESSAGE = "Input data does not match expected form";
    private final ObjectMapper cborMapper;

    CborConverter(@NotNull ObjectMapper cborMapper) {
        AssertUtil.notNull(cborMapper, "cborMapper must not be null");
        AssertUtil.isTrue(cborMapper.getFactory() instanceof CBORFactory, "factory of cborMapper must be CBORFactory.");
        this.cborMapper = cborMapper;
    }

    public void registerModule(Module module) {
        this.cborMapper.registerModule(module);
    }

    @Nullable
    public <T> T readValue(@NotNull byte[] src, @NotNull Class<T> valueType) {
        try {
            return (T)this.cborMapper.readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException | ValueInstantiationException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    public <T> T readValue(@NotNull InputStream src, @NotNull Class<T> valueType) {
        try {
            return (T)this.cborMapper.readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException | ValueInstantiationException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    public <T> T readValue(@NotNull byte[] src, @NotNull TypeReference<T> valueTypeRef) {
        try {
            return (T)this.cborMapper.readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException | ValueInstantiationException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    public <T> T readValue(@NotNull InputStream src, @NotNull TypeReference<T> valueTypeRef) {
        try {
            return (T)this.cborMapper.readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException | ValueInstantiationException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public JsonNode readTree(@NotNull byte[] bytes) {
        try {
            return this.cborMapper.readTree(bytes);
        }
        catch (JsonParseException | MismatchedInputException | ValueInstantiationException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public byte[] writeValueAsBytes(@Nullable Object value) {
        try {
            return this.cborMapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

