/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.util.Arrays;
import java.util.EnumSet;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.x500.cert.KeyUsage;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public final class KeyUsageExtension
extends X509CertificateExtension {
    private final EnumSet<KeyUsage> keyUsage;

    public KeyUsageExtension(KeyUsage ... keyUsage) {
        this(true, keyUsage);
    }

    public KeyUsageExtension(boolean critical, KeyUsage ... keyUsage) {
        super(critical);
        Assert.checkNotNullParam((String)"keyUsage", (Object)keyUsage);
        this.keyUsage = EnumSet.copyOf(Arrays.asList(keyUsage));
    }

    @Override
    public String getId() {
        return "2.5.29.15";
    }

    public void encodeTo(ASN1Encoder encoder) {
        encoder.encodeBitString(this.keyUsage);
    }
}

